/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probabilitytest;

import aima.probability.BayesNet;
import aima.probability.BayesNetNode;
import aima.probability.EnumerationAsk;
import aima.probability.Query;
import junit.framework.TestCase;

public class EnumerationAskTest
extends TestCase {
    public void testEnumerationAskAimaExample() {
        Query query = new Query("Burglary", new String[]{"JohnCalls", "MaryCalls"}, new boolean[]{true, true});
        double[] dArray = EnumerationAsk.ask(query, this.createBurglaryNetwork());
        EnumerationAskTest.assertEquals((double)0.284, (double)dArray[0], (double)0.001);
        EnumerationAskTest.assertEquals((double)0.716, (double)dArray[1], (double)0.001);
    }

    public void testEnumerationAllVariablesExcludingQueryKnown() {
        Query query = new Query("Alarm", new String[]{"Burglary", "EarthQuake", "JohnCalls", "MaryCalls"}, new boolean[]{false, false, true, true});
        double[] dArray = EnumerationAsk.ask(query, this.createBurglaryNetwork());
        EnumerationAskTest.assertEquals((double)0.557, (double)dArray[0], (double)0.001);
        EnumerationAskTest.assertEquals((double)0.442, (double)dArray[1], (double)0.001);
    }

    private BayesNet createBurglaryNetwork() {
        BayesNetNode bayesNetNode = new BayesNetNode("Burglary");
        BayesNetNode bayesNetNode2 = new BayesNetNode("EarthQuake");
        BayesNetNode bayesNetNode3 = new BayesNetNode("Alarm");
        BayesNetNode bayesNetNode4 = new BayesNetNode("JohnCalls");
        BayesNetNode bayesNetNode5 = new BayesNetNode("MaryCalls");
        bayesNetNode3.influencedBy(bayesNetNode, bayesNetNode2);
        bayesNetNode4.influencedBy(bayesNetNode3);
        bayesNetNode5.influencedBy(bayesNetNode3);
        bayesNetNode.setProbability(true, 0.001);
        bayesNetNode2.setProbability(true, 0.002);
        bayesNetNode3.setProbability(true, true, 0.95);
        bayesNetNode3.setProbability(true, false, 0.94);
        bayesNetNode3.setProbability(false, true, 0.29);
        bayesNetNode3.setProbability(false, false, 0.001);
        bayesNetNode4.setProbability(true, 0.9);
        bayesNetNode4.setProbability(false, 0.05);
        bayesNetNode5.setProbability(true, 0.7);
        bayesNetNode5.setProbability(false, 0.01);
        BayesNet bayesNet = new BayesNet(bayesNetNode, bayesNetNode2);
        return bayesNet;
    }
}

