/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.algorithms.PLResolution;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import java.util.Set;
import junit.framework.TestCase;

public class PLResolutionTest
extends TestCase {
    private PLResolution resolution;
    private PEParser parser;

    public void setUp() {
        this.resolution = new PLResolution();
        this.parser = new PEParser();
    }

    public void testPLResolveWithOneLiteralMatching() {
        Sentence sentence = (Sentence)this.parser.parse("(A OR B)");
        Sentence sentence2 = (Sentence)this.parser.parse("((NOT B) OR C)");
        Sentence sentence3 = (Sentence)this.parser.parse("(A OR C)");
        Set<Sentence> set = this.resolution.plResolve(sentence, sentence2);
        PLResolutionTest.assertEquals((int)1, (int)set.size());
        PLResolutionTest.assertTrue((boolean)set.contains(sentence3));
    }

    public void testPLResolveWithNoLiteralMatching() {
        Sentence sentence = (Sentence)this.parser.parse("(A OR B)");
        Sentence sentence2 = (Sentence)this.parser.parse("(C OR D)");
        Set<Sentence> set = this.resolution.plResolve(sentence, sentence2);
        PLResolutionTest.assertEquals((int)0, (int)set.size());
    }

    public void testPLResolveWithOneLiteralSentencesMatching() {
        Sentence sentence = (Sentence)this.parser.parse("A");
        Sentence sentence2 = (Sentence)this.parser.parse("(NOT A)");
        Set<Sentence> set = this.resolution.plResolve(sentence, sentence2);
        PLResolutionTest.assertEquals((int)1, (int)set.size());
        PLResolutionTest.assertTrue((boolean)set.contains(new Symbol("EMPTY_CLAUSE")));
    }

    public void testPLResolveWithTwoLiteralsMatching() {
        Sentence sentence = (Sentence)this.parser.parse("((NOT P21) OR B11)");
        Sentence sentence2 = (Sentence)this.parser.parse("(((NOT B11) OR P21) OR P12)");
        Sentence sentence3 = (Sentence)this.parser.parse("(  ( P12 OR P21 ) OR  ( NOT P21 )  )");
        Sentence sentence4 = (Sentence)this.parser.parse("(  ( B11 OR P12 ) OR  ( NOT B11 )  )");
        Set<Sentence> set = this.resolution.plResolve(sentence, sentence2);
        PLResolutionTest.assertEquals((int)2, (int)set.size());
        PLResolutionTest.assertTrue((boolean)set.contains(sentence3));
        PLResolutionTest.assertTrue((boolean)set.contains(sentence4));
    }

    public void testPLResolve1() {
        boolean bl = this.resolution.plResolution("((B11 =>  (NOT P11)) AND B11)", "(P11)");
        PLResolutionTest.assertEquals((boolean)false, (boolean)bl);
    }

    public void testPLResolve2() {
        boolean bl = this.resolution.plResolution("(A AND B)", "B");
        PLResolutionTest.assertEquals((boolean)true, (boolean)bl);
    }

    public void testPLResolve3() {
        boolean bl = this.resolution.plResolution("((B11 =>  (NOT P11)) AND B11)", "(NOT P11)");
        PLResolutionTest.assertEquals((boolean)true, (boolean)bl);
    }

    public void testPLResolve4() {
        boolean bl = this.resolution.plResolution("(A OR B)", "B");
        PLResolutionTest.assertEquals((boolean)false, (boolean)bl);
    }

    public void testPLResolve5() {
        boolean bl = this.resolution.plResolution("((B11 =>  (NOT P11)) AND B11)", "(NOT B11)");
        PLResolutionTest.assertEquals((boolean)false, (boolean)bl);
    }

    public void testMultipleClauseResolution() {
        PLResolution pLResolution = new PLResolution();
        KnowledgeBase knowledgeBase = new KnowledgeBase();
        String string = "((B11 <=> (P12 OR P21)) AND (NOT B11))";
        knowledgeBase.tell(string);
        pLResolution.plResolution(knowledgeBase, "(B)");
    }
}

