/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import junit.framework.TestCase;

public class KnowledgeBaseTest
extends TestCase {
    private KnowledgeBase kb;

    public void setUp() {
        this.kb = new KnowledgeBase();
    }

    public void testTellInsertsSentence() {
        this.kb.tell("(A AND B)");
        KnowledgeBaseTest.assertEquals((int)1, (int)this.kb.size());
    }

    public void testTellDoesNotInsertSameSentenceTwice() {
        this.kb.tell("(A AND B)");
        KnowledgeBaseTest.assertEquals((int)1, (int)this.kb.size());
        this.kb.tell("(A AND B)");
        KnowledgeBaseTest.assertEquals((int)1, (int)this.kb.size());
    }

    public void testEmptyKnowledgeBaseIsAnEmptyString() {
        KnowledgeBaseTest.assertEquals((String)"", (String)this.kb.toString());
    }

    public void testKnowledgeBaseWithOneSentenceToString() {
        this.kb.tell("(A AND B)");
        KnowledgeBaseTest.assertEquals((String)" ( A AND B )", (String)this.kb.toString());
    }

    public void testKnowledgeBaseWithTwoSentencesToString() {
        this.kb.tell("(A AND B)");
        this.kb.tell("(C AND D)");
        KnowledgeBaseTest.assertEquals((String)" (  ( A AND B ) AND  ( C AND D ) )", (String)this.kb.toString());
    }

    public void testKnowledgeBaseWithThreeSentencesToString() {
        this.kb.tell("(A AND B)");
        this.kb.tell("(C AND D)");
        this.kb.tell("(E AND F)");
        KnowledgeBaseTest.assertEquals((String)" (  (  ( A AND B ) AND  ( C AND D ) ) AND  ( E AND F ) )", (String)this.kb.toString());
    }
}

