/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.algorithms;

import aima.logic.propositional.algorithms.DPLL;
import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.Converter;
import java.util.List;
import junit.framework.TestCase;

public class DPLLTest
extends TestCase {
    private KnowledgeBase one;
    private KnowledgeBase two;
    private KnowledgeBase three;
    private KnowledgeBase four;
    private DPLL dpll;
    private PEParser parser;

    public void setUp() {
        this.parser = new PEParser();
        this.dpll = new DPLL();
    }

    public void testDPLLReturnsTrueWhenAllClausesTrueInModel() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND (A OR B))");
        boolean bl = this.dpll.dpllSatisfiable(sentence, model);
        DPLLTest.assertEquals((boolean)true, (boolean)bl);
    }

    public void testDPLLReturnsFalseWhenOneClauseFalseInModel() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), false);
        Sentence sentence = (Sentence)this.parser.parse("((A OR B) AND (A => B))");
        boolean bl = this.dpll.dpllSatisfiable(sentence, model);
        DPLLTest.assertEquals((boolean)false, (boolean)bl);
    }

    public void testDPLLFiltersClausesTheStatusOfWhichAreKnown() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND (B AND C))");
        List<Sentence> list = new Converter<Sentence>().setToList(new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(sentence)));
        List<Sentence> list2 = this.dpll.clausesWithNonTrueValues(list, model);
        DPLLTest.assertEquals((int)1, (int)list2.size());
        Sentence sentence2 = (Sentence)this.parser.parse("(B AND C)");
        list2.contains(sentence2);
    }

    public void testDPLLFilteringNonTrueClausesGivesNullWhenAllClausesAreKnown() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true).extend(new Symbol("C"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND (B AND C))");
        List<Sentence> list = new Converter<Sentence>().setToList(new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(sentence)));
        List<Sentence> list2 = this.dpll.clausesWithNonTrueValues(list, model);
        DPLLTest.assertEquals((int)0, (int)list2.size());
    }

    public void testDPLLFindsPurePositiveSymbolsWhenTheyExist() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND (B AND C))");
        List<Sentence> list = new Converter<Sentence>().setToList(new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(sentence)));
        List<Symbol> list2 = new Converter<Symbol>().setToList(new SymbolCollector().getSymbolsIn(sentence));
        DPLL.SymbolValuePair symbolValuePair = this.dpll.findPureSymbolValuePair(list, model, list2);
        DPLLTest.assertNotNull((Object)symbolValuePair);
        DPLLTest.assertEquals((Object)new Symbol("C"), (Object)symbolValuePair.symbol);
        DPLLTest.assertEquals((Object)new Boolean(true), (Object)symbolValuePair.value);
    }

    public void testDPLLFindsPureNegativeSymbolsWhenTheyExist() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND ( B  AND (NOT C) ))");
        List<Sentence> list = new Converter<Sentence>().setToList(new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(sentence)));
        List<Symbol> list2 = new Converter<Symbol>().setToList(new SymbolCollector().getSymbolsIn(sentence));
        DPLL.SymbolValuePair symbolValuePair = this.dpll.findPureSymbolValuePair(list, model, list2);
        DPLLTest.assertNotNull((Object)symbolValuePair);
        DPLLTest.assertEquals((Object)new Symbol("C"), (Object)symbolValuePair.symbol);
        DPLLTest.assertEquals((Object)new Boolean(false), (Object)symbolValuePair.value);
    }

    public void testDPLLSucceedsWithAandNotA() {
        Sentence sentence = (Sentence)this.parser.parse("(A AND (NOT A))");
        boolean bl = this.dpll.dpllSatisfiable(sentence);
        DPLLTest.assertEquals((boolean)false, (boolean)bl);
    }

    public void testDPLLSucceedsWithChadCarffsBugReport() {
        KnowledgeBase knowledgeBase = new KnowledgeBase();
        knowledgeBase.tell("(B12 <=> (P11 OR (P13 OR (P22 OR P02))))");
        knowledgeBase.tell("(B21 <=> (P20 OR (P22 OR (P31 OR P11))))");
        knowledgeBase.tell("(B01 <=> (P00 OR (P02 OR P11)))");
        knowledgeBase.tell("(B10 <=> (P11 OR (P20 OR P00)))");
        knowledgeBase.tell("(NOT B21)");
        knowledgeBase.tell("(NOT B12)");
        knowledgeBase.tell("(B10)");
        knowledgeBase.tell("(B01)");
        DPLLTest.assertTrue((boolean)knowledgeBase.askWithDpll("(P00)"));
        DPLLTest.assertFalse((boolean)knowledgeBase.askWithDpll("(NOT P00)"));
    }

    public void testDPLLSucceedsWithStackOverflowBugReport1() {
        KnowledgeBase knowledgeBase = new KnowledgeBase();
        Sentence sentence = (Sentence)this.parser.parse("((A OR (NOT A)) AND (A OR B))");
        DPLLTest.assertTrue((boolean)this.dpll.dpllSatisfiable(sentence));
    }

    public void testDPLLSucceedsWithChadCarffsBugReport2() {
        KnowledgeBase knowledgeBase = new KnowledgeBase();
        knowledgeBase.tell("(B10 <=> (P11 OR (P20 OR P00)))");
        knowledgeBase.tell("(B01 <=> (P00 OR (P02 OR P11)))");
        knowledgeBase.tell("(B21 <=> (P20 OR (P22 OR (P31 OR P11))))");
        knowledgeBase.tell("(B12 <=> (P11 OR (P13 OR (P22 OR P02))))");
        knowledgeBase.tell("(NOT B21)");
        knowledgeBase.tell("(NOT B12)");
        knowledgeBase.tell("(B10)");
        knowledgeBase.tell("(B01)");
        DPLLTest.assertTrue((boolean)knowledgeBase.askWithDpll("(P00)"));
        DPLLTest.assertFalse((boolean)knowledgeBase.askWithDpll("(NOT P00)"));
    }
}

