/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.FOLKnowledgeBaseFactory;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.TestCase;

public abstract class CommonFOLInferenceProcedureTests
extends TestCase {
    protected void testDefiniteClauseKBKingsQueryCriminalXFalse(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Variable("x"));
        Predicate predicate = new Predicate("Criminal", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
    }

    protected void testDefiniteClauseKBKingsQueryRichardEvilFalse(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("Richard"));
        Predicate predicate = new Predicate("Evil", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
    }

    protected void testDefiniteClauseKBKingsQueryJohnEvilSucceeds(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("John"));
        Predicate predicate = new Predicate("Evil", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
    }

    protected void testDefiniteClauseKBKingsQueryEvilXReturnsJohnSucceeds(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Variable("x"));
        Predicate predicate = new Predicate("Evil", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertEquals((Object)new Constant("John"), (Object)inferenceResult.getProofs().get(0).getAnswerBindings().get(new Variable("x")));
    }

    protected void testDefiniteClauseKBKingsQueryKingXReturnsJohnAndRichardSucceeds(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Variable("x"));
        Predicate predicate = new Predicate("King", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((2 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().get(1).getAnswerBindings().size() ? 1 : 0) != 0);
        boolean bl = false;
        boolean bl2 = false;
        Constant constant = new Constant("John");
        Constant constant2 = new Constant("Richard");
        for (Proof proof : inferenceResult.getProofs()) {
            Map<Variable, Term> map = proof.getAnswerBindings();
            CommonFOLInferenceProcedureTests.assertEquals((int)1, (int)map.size());
            if (constant.equals(map.get(new Variable("x")))) {
                bl2 = true;
            }
            if (!constant2.equals(map.get(new Variable("x")))) continue;
            bl = true;
        }
        CommonFOLInferenceProcedureTests.assertTrue((boolean)bl2);
        CommonFOLInferenceProcedureTests.assertTrue((boolean)bl);
    }

    protected void testDefiniteClauseKBWeaponsQueryCriminalXReturnsWestSucceeds(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createWeaponsKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Variable("x"));
        Predicate predicate = new Predicate("Criminal", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertEquals((Object)new Constant("West"), (Object)inferenceResult.getProofs().get(0).getAnswerBindings().get(new Variable("x")));
    }

    protected void testHornClauseKBRingOfThievesQuerySkisXReturnsNancyRedBertDrew(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createRingOfThievesKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Variable("x"));
        Predicate predicate = new Predicate("Skis", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertEquals((int)4, (int)inferenceResult.getProofs().size());
        CommonFOLInferenceProcedureTests.assertEquals((int)1, (int)inferenceResult.getProofs().get(0).getAnswerBindings().size());
        CommonFOLInferenceProcedureTests.assertEquals((int)1, (int)inferenceResult.getProofs().get(1).getAnswerBindings().size());
        CommonFOLInferenceProcedureTests.assertEquals((int)1, (int)inferenceResult.getProofs().get(2).getAnswerBindings().size());
        CommonFOLInferenceProcedureTests.assertEquals((int)1, (int)inferenceResult.getProofs().get(3).getAnswerBindings().size());
        ArrayList<Constant> arrayList2 = new ArrayList<Constant>();
        arrayList2.add(new Constant("Nancy"));
        arrayList2.add(new Constant("Red"));
        arrayList2.add(new Constant("Bert"));
        arrayList2.add(new Constant("Drew"));
        for (Proof proof : inferenceResult.getProofs()) {
            arrayList2.remove(proof.getAnswerBindings().get(new Variable("x")));
        }
        CommonFOLInferenceProcedureTests.assertEquals((int)0, (int)arrayList2.size());
    }

    protected void testFullFOLKBLovesAnimalQueryKillsCuriosityTunaSucceeds(InferenceProcedure inferenceProcedure, boolean bl) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createLovesAnimalKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("Curiosity"));
        arrayList.add(new Constant("Tuna"));
        Predicate predicate = new Predicate("Kills", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        if (bl) {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        } else {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        }
    }

    protected void testFullFOLKBLovesAnimalQueryNotKillsJackTunaSucceeds(InferenceProcedure inferenceProcedure, boolean bl) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createLovesAnimalKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("Jack"));
        arrayList.add(new Constant("Tuna"));
        NotSentence notSentence = new NotSentence(new Predicate("Kills", arrayList));
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(notSentence);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        if (bl) {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        } else {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        }
    }

    protected void testFullFOLKBLovesAnimalQueryKillsJackTunaFalse(InferenceProcedure inferenceProcedure, boolean bl) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createLovesAnimalKnowledgeBase(inferenceProcedure);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("Jack"));
        arrayList.add(new Constant("Tuna"));
        Predicate predicate = new Predicate("Kills", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        if (bl) {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        } else {
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        }
    }

    protected void testEqualityAxiomsKBabcAEqualsCSucceeds(InferenceProcedure inferenceProcedure) {
        TermEquality termEquality;
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createABCEqualityKnowledgeBase(inferenceProcedure, true);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(termEquality = new TermEquality(new Constant("A"), new Constant("C")));
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
    }

    protected void testEqualityAndSubstitutionAxiomsKBabcdFFASucceeds(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(inferenceProcedure, true);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("A"));
        Function function = new Function("F", arrayList);
        arrayList = new ArrayList();
        arrayList.add(function);
        TermEquality termEquality = new TermEquality(new Function("F", arrayList), new Constant("A"));
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(termEquality);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
    }

    protected void xtestEqualityAndSubstitutionAxiomsKBabcdPDSucceeds(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(inferenceProcedure, true);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("D"));
        Predicate predicate = new Predicate("P", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
    }

    protected void testEqualityAndSubstitutionAxiomsKBabcdPFFASucceeds(InferenceProcedure inferenceProcedure, boolean bl) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(inferenceProcedure, true);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("A"));
        Function function = new Function("F", arrayList);
        arrayList = new ArrayList();
        arrayList.add(function);
        Function function2 = new Function("F", arrayList);
        arrayList = new ArrayList();
        arrayList.add(function2);
        Predicate predicate = new Predicate("P", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        if (bl) {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        } else {
            CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        }
    }

    protected void testEqualityNoAxiomsKBabcAEqualsCSucceeds(InferenceProcedure inferenceProcedure, boolean bl) {
        TermEquality termEquality;
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createABCEqualityKnowledgeBase(inferenceProcedure, false);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(termEquality = new TermEquality(new Constant("A"), new Constant("C")));
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        if (bl) {
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        } else {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        }
    }

    protected void testEqualityAndSubstitutionNoAxiomsKBabcdFFASucceeds(InferenceProcedure inferenceProcedure, boolean bl) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(inferenceProcedure, false);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("A"));
        Function function = new Function("F", arrayList);
        arrayList = new ArrayList();
        arrayList.add(function);
        TermEquality termEquality = new TermEquality(new Function("F", arrayList), new Constant("A"));
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(termEquality);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        if (bl) {
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        } else {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        }
    }

    protected void testEqualityAndSubstitutionNoAxiomsKBabcdPDSucceeds(InferenceProcedure inferenceProcedure, boolean bl) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(inferenceProcedure, false);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("D"));
        Predicate predicate = new Predicate("P", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        if (bl) {
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        } else {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        }
    }

    protected void testEqualityAndSubstitutionNoAxiomsKBabcdPFFASucceeds(InferenceProcedure inferenceProcedure, boolean bl) {
        FOLKnowledgeBase fOLKnowledgeBase = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(inferenceProcedure, false);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("A"));
        Function function = new Function("F", arrayList);
        arrayList = new ArrayList();
        arrayList.add(function);
        Function function2 = new Function("F", arrayList);
        arrayList = new ArrayList();
        arrayList.add(function2);
        Predicate predicate = new Predicate("P", arrayList);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(predicate);
        CommonFOLInferenceProcedureTests.assertTrue((null != inferenceResult ? 1 : 0) != 0);
        if (bl) {
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
        } else {
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue((boolean)inferenceResult.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue((1 == inferenceResult.getProofs().size() ? 1 : 0) != 0);
            CommonFOLInferenceProcedureTests.assertTrue((0 == inferenceResult.getProofs().get(0).getAnswerBindings().size() ? 1 : 0) != 0);
        }
    }
}

