/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.util.Util;
import java.util.Hashtable;
import junit.framework.TestCase;

public class InformationAndGainTest
extends TestCase {
    public void testInformationCalculation() {
        double[] dArray = new double[]{0.5, 0.5};
        double[] dArray2 = new double[]{0.01, 0.99};
        InformationAndGainTest.assertEquals((Object)1.0, (Object)Util.information(dArray));
        InformationAndGainTest.assertEquals((Object)0.08079313589591118, (Object)Util.information(dArray2));
    }

    public void testBasicDataSetInformationCalculation() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        double d = dataSet.getInformationFor();
        InformationAndGainTest.assertEquals((Object)1.0, (Object)d);
    }

    public void testDataSetSplit() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        Hashtable<String, DataSet> hashtable = dataSet.splitByAttribute("patrons");
        InformationAndGainTest.assertEquals((int)3, (int)hashtable.keySet().size());
        InformationAndGainTest.assertEquals((int)6, (int)hashtable.get("Full").size());
        InformationAndGainTest.assertEquals((int)2, (int)hashtable.get("None").size());
        InformationAndGainTest.assertEquals((int)4, (int)hashtable.get("Some").size());
    }

    public void testGainCalculation() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        Hashtable<String, DataSet> hashtable = dataSet.splitByAttribute("patrons");
        double d = dataSet.calculateGainFor("patrons");
        InformationAndGainTest.assertEquals((double)0.541, (double)d, (double)0.001);
        d = dataSet.calculateGainFor("type");
        InformationAndGainTest.assertEquals((double)0.0, (double)d, (double)0.001);
    }
}

