/*
 * Decompiled with CFR 0.152.
 */
package aima.search.online;

import aima.basic.Agent;
import aima.basic.Percept;
import aima.search.framework.Problem;
import aima.search.framework.Successor;
import aima.search.online.ActionState;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class LRTAStarAgent
extends Agent {
    private Problem problem;
    private final Hashtable<ActionState, Percept> result = new Hashtable();
    private final Hashtable<Percept, Double> H = new Hashtable();
    private Percept s = null;
    private Object a = null;

    public LRTAStarAgent(Problem problem) {
        this.setProblem(problem);
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(Problem problem) {
        this.problem = problem;
        this.init();
    }

    @Override
    public String execute(Percept percept) {
        if (!this.goalTest(percept)) {
            double d;
            double d2;
            if (!this.H.containsKey(percept)) {
                this.H.put(percept, this.getProblem().getHeuristicFunction().getHeuristicValue(percept));
            }
            if (null != this.s) {
                this.result.put(new ActionState(this.a, this.s), percept);
                d2 = Double.MAX_VALUE;
                for (Object object : this.actions(this.s)) {
                    d = this.lrtaCost(this.s, object, this.result.get(new ActionState(object, this.s)));
                    if (!(d < d2)) continue;
                    d2 = d;
                }
                this.H.put(this.s, d2);
            }
            d2 = Double.MAX_VALUE;
            this.a = "NoOP";
            for (Object object : this.actions(percept)) {
                d = this.lrtaCost(percept, object, this.result.get(new ActionState(object, percept)));
                if (!(d < d2)) continue;
                d2 = d;
                this.a = object;
            }
        } else {
            this.a = "NoOP";
        }
        this.s = percept;
        if ("NoOP".equals(this.a)) {
            this.die();
        }
        return this.a.toString();
    }

    private void init() {
        this.live();
        this.result.clear();
        this.H.clear();
        this.s = null;
        this.a = null;
    }

    private boolean goalTest(Percept percept) {
        return this.getProblem().isGoalState(percept);
    }

    private double lrtaCost(Percept percept, Object object, Percept percept2) {
        if (null == percept2) {
            return this.getProblem().getHeuristicFunction().getHeuristicValue(percept);
        }
        return this.getProblem().getStepCostFunction().calculateStepCost(percept, percept2, object.toString()) + this.H.get(percept2);
    }

    private List<Object> actions(Percept percept) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = this.getProblem().getSuccessorFunction().getSuccessors(percept);
        for (Successor successor : list) {
            arrayList.add(successor.getAction());
        }
        return arrayList;
    }
}

