/*
 * Decompiled with CFR 0.152.
 */
package aima.search.nodestore;

import aima.search.framework.Node;
import aima.search.framework.NodeStore;
import java.util.Hashtable;
import java.util.List;

public class CachedStateNodeStore
implements NodeStore {
    private NodeStore nodeStore;
    private Hashtable<Object, Node> cachedState = new Hashtable();

    public CachedStateNodeStore(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    public boolean containsNodeBasedOn(Object object) {
        return this.cachedState.containsKey(object);
    }

    public Node getNodeBasedOn(Object object) {
        return this.cachedState.get(object);
    }

    @Override
    public void add(Node node) {
        this.nodeStore.add(node);
        this.cachedState.put(node.getState(), node);
    }

    @Override
    public Node remove() {
        Node node = this.nodeStore.remove();
        this.cachedState.remove(node.getState());
        return node;
    }

    @Override
    public void add(List<Node> list) {
        this.nodeStore.add(list);
        for (Node node : list) {
            this.cachedState.put(node.getState(), node);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.nodeStore.isEmpty();
    }

    @Override
    public int size() {
        return this.nodeStore.size();
    }
}

