/*
 * Decompiled with CFR 0.152.
 */
package aima.search.informed.ga;

import aima.search.framework.GoalTest;
import aima.search.framework.Metrics;
import aima.search.informed.ga.FitnessFunction;
import aima.util.Util;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class GeneticAlgorithm {
    protected Metrics metrics = new Metrics();
    protected static final String POPULATION_SIZE = "populationSize";
    protected static final String ITERATIONS = "iterations";
    private final int individualLength;
    private final Character[] finiteAlphabet;
    private final double mutationProbability;
    private final Random random = new Random();

    public GeneticAlgorithm(int n, Set<Character> set, double d) {
        this.individualLength = n;
        this.finiteAlphabet = set.toArray(new Character[set.size()]);
        this.mutationProbability = d;
        assert (this.mutationProbability >= 0.0 && this.mutationProbability <= 1.0);
    }

    public String geneticAlgorithm(Set<String> set, FitnessFunction fitnessFunction, GoalTest goalTest) {
        String string = null;
        this.validatePopulation(set);
        this.clearInstrumentation();
        this.setPopulationSize(set.size());
        int n = 0;
        do {
            string = this.ga(set, fitnessFunction);
            ++n;
        } while (!goalTest.isGoalState(string));
        this.setIterations(n);
        return string;
    }

    public String geneticAlgorithm(Set<String> set, FitnessFunction fitnessFunction, int n) {
        String string = null;
        this.validatePopulation(set);
        this.clearInstrumentation();
        this.setPopulationSize(set.size());
        for (int i = 0; i < n; ++i) {
            string = this.ga(set, fitnessFunction);
        }
        this.setIterations(n);
        return string;
    }

    public void clearInstrumentation() {
        this.setPopulationSize(0);
        this.setIterations(0);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public int getPopulationSize() {
        return this.metrics.getInt(POPULATION_SIZE);
    }

    public void setPopulationSize(int n) {
        this.metrics.set(POPULATION_SIZE, n);
    }

    public int getIterations() {
        return this.metrics.getInt(ITERATIONS);
    }

    public void setIterations(int n) {
        this.metrics.set(ITERATIONS, n);
    }

    private void validatePopulation(Set<String> set) {
        assert (set.size() >= 1);
        for (String string : set) {
            assert (string.length() == this.individualLength);
        }
    }

    private String ga(Set<String> set, FitnessFunction fitnessFunction) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < set.size(); ++i) {
            String string = this.randomSelection(set, fitnessFunction);
            String string2 = this.randomSelection(set, fitnessFunction);
            String string3 = this.reproduce(string, string2);
            if (this.random.nextDouble() <= this.mutationProbability) {
                string3 = this.mutate(string3);
            }
            hashSet.add(string3);
        }
        set.clear();
        set.addAll(hashSet);
        return this.retrieveBestIndividual(set, fitnessFunction);
    }

    private String randomSelection(Set<String> set, FitnessFunction fitnessFunction) {
        String string = null;
        double[] dArray = new double[set.size()];
        String[] stringArray = set.toArray(new String[set.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = fitnessFunction.getValue(stringArray[i]);
        }
        dArray = Util.normalize(dArray);
        double d = this.random.nextDouble();
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d <= (d2 += dArray[i]))) continue;
            string = stringArray[i];
            break;
        }
        if (null == string) {
            string = stringArray[stringArray.length - 1];
        }
        return string;
    }

    private String reproduce(String string, String string2) {
        int n = this.randomOffset(this.individualLength);
        return string.substring(0, n) + string2.substring(n);
    }

    private String mutate(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = this.randomOffset(this.individualLength);
        int n2 = this.randomOffset(this.finiteAlphabet.length);
        stringBuffer.setCharAt(n, this.finiteAlphabet[n2].charValue());
        return stringBuffer.toString();
    }

    private String retrieveBestIndividual(Set<String> set, FitnessFunction fitnessFunction) {
        String string = null;
        double d = Double.MIN_VALUE;
        for (String string2 : set) {
            double d2 = fitnessFunction.getValue(string2);
            if (!(d2 > d)) continue;
            string = string2;
            d = d2;
        }
        return string;
    }

    private int randomOffset(int n) {
        return this.random.nextInt(n);
    }
}

