/*
 * Decompiled with CFR 0.152.
 */
package aima.search.demos;

import aima.basic.BasicEnvironmentView;
import aima.search.framework.GraphSearch;
import aima.search.framework.HeuristicFunction;
import aima.search.framework.Search;
import aima.search.framework.TreeSearch;
import aima.search.informed.AStarEvaluationFunction;
import aima.search.informed.RecursiveBestFirstSearch;
import aima.search.map.ExtendableMap;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.map.Point2D;
import aima.search.map.SimplifiedRoadMapOfPartOfRomania;
import aima.search.uninformed.BidirectionalSearch;
import aima.search.uninformed.BreadthFirstSearch;
import aima.search.uninformed.DepthFirstSearch;
import aima.search.uninformed.DepthLimitedSearch;
import aima.search.uninformed.IterativeDeepeningSearch;
import aima.search.uninformed.UniformCostSearch;

public class MapDemo {
    public static void main(String[] stringArray) {
        MapDemo.newMapDemo();
    }

    private static void newMapDemo() {
        MapDemo.mapWithBreadthFirstSearch();
        MapDemo.mapWithUniformCostSearch();
        MapDemo.mapWithDepthFirstSearch();
        MapDemo.mapWithRecursiveDLS();
        MapDemo.mapWithIterativeDeepeningSearch();
        MapDemo.mapWithBidrectionalSearch();
        MapDemo.mapWithRecursiveBestFirstSearch();
    }

    private static void mapWithBreadthFirstSearch() {
        System.out.println("\nMapDemo BFS -->");
        MapEnvironment mapEnvironment = new MapEnvironment(new SimplifiedRoadMapOfPartOfRomania());
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new BreadthFirstSearch(new GraphSearch()), 2);
        mapEnvironment.addAgent(mapAgent, "Arad");
        mapEnvironment.registerView(new BasicEnvironmentView());
        mapEnvironment.stepUntilDone();
    }

    private static void mapWithUniformCostSearch() {
        System.out.println("\nMapDemo UCS (using a TreeSearch) -->");
        MapEnvironment mapEnvironment = new MapEnvironment(new SimplifiedRoadMapOfPartOfRomania());
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new UniformCostSearch(new TreeSearch()), new String[]{"Bucharest"});
        mapEnvironment.addAgent(mapAgent, "Arad");
        mapEnvironment.registerView(new BasicEnvironmentView());
        mapEnvironment.stepUntilDone();
        System.out.println("\nMapDemo UCS (using a GraphSearch) -->");
        mapEnvironment = new MapEnvironment(new SimplifiedRoadMapOfPartOfRomania());
        mapAgent = new MapAgent(mapEnvironment, (Search)new UniformCostSearch(new GraphSearch()), new String[]{"Bucharest"});
        mapEnvironment.addAgent(mapAgent, "Arad");
        mapEnvironment.registerView(new BasicEnvironmentView());
        mapEnvironment.stepUntilDone();
    }

    private static void mapWithDepthFirstSearch() {
        System.out.println("\nMapDemo DFS -->");
        MapEnvironment mapEnvironment = new MapEnvironment(new SimplifiedRoadMapOfPartOfRomania());
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new DepthFirstSearch(new GraphSearch()), 2);
        mapEnvironment.addAgent(mapAgent, "Arad");
        mapEnvironment.registerView(new BasicEnvironmentView());
        mapEnvironment.stepUntilDone();
    }

    private static void mapWithRecursiveDLS() {
        System.out.println("\nMapDemo recursive DLS -->");
        MapEnvironment mapEnvironment = new MapEnvironment(new SimplifiedRoadMapOfPartOfRomania());
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new DepthLimitedSearch(8), 2);
        mapEnvironment.addAgent(mapAgent, "Arad");
        mapEnvironment.registerView(new BasicEnvironmentView());
        mapEnvironment.stepUntilDone();
    }

    private static void mapWithIterativeDeepeningSearch() {
        System.out.println("\nMapDemo Iterative DS  -->");
        MapEnvironment mapEnvironment = new MapEnvironment(new SimplifiedRoadMapOfPartOfRomania());
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new IterativeDeepeningSearch(), 2);
        mapEnvironment.addAgent(mapAgent, "Arad");
        mapEnvironment.registerView(new BasicEnvironmentView());
        mapEnvironment.stepUntilDone();
    }

    private static void mapWithBidrectionalSearch() {
        System.out.println("\nMapDemo Bidirectional Search  -->");
        MapEnvironment mapEnvironment = new MapEnvironment(new SimplifiedRoadMapOfPartOfRomania());
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new BidirectionalSearch(), new String[]{"Bucharest"});
        mapEnvironment.addAgent(mapAgent, "Oradea");
        mapEnvironment.registerView(new BasicEnvironmentView());
        mapEnvironment.stepUntilDone();
    }

    private static void mapWithRecursiveBestFirstSearch() {
        System.out.println("\nMapDemo RecursiveBestFirstSearch Search  -->");
        MapEnvironment mapEnvironment = new MapEnvironment(new SimplifiedRoadMapOfPartOfRomania());
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new RecursiveBestFirstSearch(new AStarEvaluationFunction()), new String[]{"Bucharest"});
        mapAgent.setHeuristicFunction(new HeuristicFunction(){
            ExtendableMap map = new SimplifiedRoadMapOfPartOfRomania();

            @Override
            public double getHeuristicValue(Object object) {
                Point2D point2D = this.map.getPosition((String)object);
                Point2D point2D2 = this.map.getPosition("Bucharest");
                return point2D.distance(point2D2);
            }
        });
        mapEnvironment.addAgent(mapAgent, "Arad");
        mapEnvironment.registerView(new BasicEnvironmentView());
        mapEnvironment.stepUntilDone();
    }
}

