/*
 * Decompiled with CFR 0.152.
 */
package aima.search.csp;

import aima.search.csp.Constraint;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class Assignment {
    Hashtable<String, Object> variablesToValues = new Hashtable();
    List<String> variables;

    public Assignment() {
        this(new ArrayList<String>());
    }

    public Assignment(List<String> list) {
        this.variables = list;
    }

    public void setAssignment(String string, Object object) {
        this.variablesToValues.put(string, object);
    }

    public Object getAssignment(String string) {
        return this.variablesToValues.get(string);
    }

    public boolean isComplete() {
        return this.everyVariableIsAKeyAndHasAValue();
    }

    private boolean everyVariableIsAKeyAndHasAValue() {
        for (String string : this.variables) {
            if (!this.variablesToValues.keySet().contains(string)) {
                return false;
            }
            if (this.variablesToValues.get(string) != null) continue;
            return false;
        }
        return true;
    }

    public void remove(String string) {
        if (this.variablesToValues.keySet().contains(string)) {
            this.variablesToValues.remove(string);
        }
    }

    public String selectFirstUnassignedVariable() {
        for (String string : this.variables) {
            if (this.variablesToValues.keySet().contains(string)) continue;
            return string;
        }
        return null;
    }

    public boolean hasAssignmentFor(String string) {
        return this.variablesToValues.keySet().contains(string);
    }

    public String toString() {
        return this.variablesToValues.toString();
    }

    public Assignment copy() {
        Assignment assignment = new Assignment();
        for (int i = 0; i < this.variables.size(); ++i) {
            assignment.variables.add(this.variables.get(i));
        }
        for (String string : this.variablesToValues.keySet()) {
            assignment.variablesToValues.put(string, this.variablesToValues.get(string));
        }
        return assignment;
    }

    public int getNumberOfConflictsFor(String string, Object object, Constraint constraint) {
        Assignment assignment = this.copy();
        assignment.setAssignment(string, object);
        return assignment.getConflictedVariables(constraint).size();
    }

    public List<String> getConflictedVariables(Constraint constraint) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.getVariables();
        for (String string : list) {
            Object object;
            if (constraint.isSatisfiedWith(this, string, object = this.getAssignment(string))) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Object getMinimumConflictingValueFor(String string, List list, Constraint constraint) {
        int n = Integer.MAX_VALUE;
        Object var5_5 = null;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (this.getNumberOfConflictsFor(string, e, constraint) >= n) continue;
            n = this.getNumberOfConflictsFor(string, e, constraint);
            var5_5 = e;
        }
        return var5_5;
    }

    public boolean satisfies(Constraint constraint) {
        if (this.isComplete()) {
            for (int i = 0; i < this.getVariables().size(); ++i) {
                Object object;
                String string = this.getVariables().get(i);
                if (constraint.isSatisfiedWith(this, string, object = this.getAssignment(string))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<String> getVariables() {
        return this.variables;
    }
}

