/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.probability.ProbabilityDistribution;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class BayesNetNode {
    private String variable;
    List<BayesNetNode> parents;
    List<BayesNetNode> children;
    ProbabilityDistribution distribution;

    public BayesNetNode(String string) {
        this.variable = string;
        this.parents = new ArrayList<BayesNetNode>();
        this.children = new ArrayList<BayesNetNode>();
        this.distribution = new ProbabilityDistribution(string);
    }

    private void addParent(BayesNetNode bayesNetNode) {
        if (!this.parents.contains(bayesNetNode)) {
            this.parents.add(bayesNetNode);
        }
    }

    private void addChild(BayesNetNode bayesNetNode) {
        if (!this.children.contains(bayesNetNode)) {
            this.children.add(bayesNetNode);
        }
    }

    public void influencedBy(BayesNetNode bayesNetNode) {
        this.addParent(bayesNetNode);
        bayesNetNode.addChild(this);
        this.distribution = new ProbabilityDistribution(bayesNetNode.getVariable());
    }

    public void influencedBy(BayesNetNode bayesNetNode, BayesNetNode bayesNetNode2) {
        this.influencedBy(bayesNetNode);
        this.influencedBy(bayesNetNode2);
        this.distribution = new ProbabilityDistribution(bayesNetNode.getVariable(), bayesNetNode2.getVariable());
    }

    public void setProbability(boolean bl, double d) {
        this.distribution.set(bl, d);
        if (this.isRoot()) {
            this.distribution.set(!bl, 1.0 - d);
        }
    }

    private boolean isRoot() {
        return this.parents.size() == 0;
    }

    public void setProbability(boolean bl, boolean bl2, double d) {
        this.distribution.set(bl, bl2, d);
    }

    public String getVariable() {
        return this.variable;
    }

    public List<BayesNetNode> getChildren() {
        return this.children;
    }

    public List<BayesNetNode> getParents() {
        return this.parents;
    }

    public String toString() {
        return this.variable;
    }

    public double probabilityOf(Hashtable hashtable) {
        return this.distribution.probabilityOf(hashtable);
    }

    public Boolean isTrueFor(double d, Hashtable<String, Boolean> hashtable) {
        Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
        if (this.isRoot()) {
            hashtable2.put(this.getVariable(), Boolean.TRUE);
        } else {
            for (int i = 0; i < this.parents.size(); ++i) {
                BayesNetNode bayesNetNode = this.parents.get(i);
                hashtable2.put(bayesNetNode.getVariable(), hashtable.get(bayesNetNode.getVariable()));
            }
        }
        double d2 = this.probabilityOf(hashtable2);
        if (d <= d2) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BayesNetNode bayesNetNode = (BayesNetNode)object;
        return this.variable.equals(bayesNetNode.variable);
    }
}

