/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.parsing;

import aima.logic.common.Lexer;
import aima.logic.common.Token;
import java.util.HashSet;
import java.util.Set;

public class PELexer
extends Lexer {
    Set<String> connectors = new HashSet<String>();

    public PELexer() {
        this.connectors.add("NOT");
        this.connectors.add("AND");
        this.connectors.add("OR");
        this.connectors.add("=>");
        this.connectors.add("<=>");
    }

    public PELexer(String string) {
        this();
        this.setInput(string);
    }

    @Override
    public Token nextToken() {
        Object var1_1 = null;
        if (this.lookAhead(1) == '(') {
            this.consume();
            return new Token(2, "(");
        }
        if (this.lookAhead(1) == ')') {
            this.consume();
            return new Token(3, ")");
        }
        if (this.identifierDetected()) {
            return this.symbol();
        }
        if (Character.isWhitespace(this.lookAhead(1))) {
            this.consume();
            return this.nextToken();
        }
        if (this.lookAhead(1) == '\uffff') {
            return new Token(9999, "EOI");
        }
        throw new RuntimeException("Lexing error on character " + this.lookAhead(1));
    }

    private boolean identifierDetected() {
        return Character.isJavaIdentifierStart((char)this.lookAheadBuffer[0]) || this.partOfConnector();
    }

    private boolean partOfConnector() {
        return this.lookAhead(1) == '=' || this.lookAhead(1) == '<' || this.lookAhead(1) == '>';
    }

    private Token symbol() {
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isLetterOrDigit(this.lookAhead(1)) || this.lookAhead(1) == '=' || this.lookAhead(1) == '<' || this.lookAhead(1) == '>') {
            stringBuffer.append(this.lookAhead(1));
            this.consume();
        }
        String string = stringBuffer.toString();
        if (this.isConnector(string)) {
            return new Token(5, stringBuffer.toString());
        }
        if (string.equalsIgnoreCase("true")) {
            return new Token(11, "TRUE");
        }
        if (string.equalsIgnoreCase("false")) {
            return new Token(12, "FALSE");
        }
        return new Token(1, stringBuffer.toString());
    }

    private Token connector() {
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isLetterOrDigit(this.lookAhead(1))) {
            stringBuffer.append(this.lookAhead(1));
            this.consume();
        }
        return new Token(5, stringBuffer.toString());
    }

    private Token whiteSpace() {
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isWhitespace(this.lookAhead(1))) {
            stringBuffer.append(this.lookAhead(1));
            this.consume();
        }
        return new Token(1000, stringBuffer.toString());
    }

    private boolean isConnector(String string) {
        return this.connectors.contains(string);
    }
}

