/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.DPLL;
import aima.logic.propositional.algorithms.TTEntails;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.util.LogicUtils;
import java.util.ArrayList;
import java.util.List;

public class KnowledgeBase {
    private List<Sentence> sentences = new ArrayList<Sentence>();
    private PEParser parser = new PEParser();

    public void tell(String string) {
        Sentence sentence = (Sentence)this.parser.parse(string);
        if (!this.sentences.contains(sentence)) {
            this.sentences.add(sentence);
        }
    }

    public void tellAll(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.tell(stringArray[i]);
        }
    }

    public int size() {
        return this.sentences.size();
    }

    public Sentence asSentence() {
        return LogicUtils.chainWith("AND", this.sentences);
    }

    public boolean askWithDpll(String string) {
        Sentence sentence = null;
        Sentence sentence2 = null;
        try {
            sentence = (Sentence)this.parser.parse(string);
        }
        catch (Exception exception) {
            System.out.println("error parsing query" + exception.getMessage());
        }
        Sentence sentence3 = this.asSentence();
        Sentence sentence4 = null;
        sentence4 = sentence3 != null ? (Sentence)this.parser.parse(" ( " + sentence3.toString() + " AND " + string + " )") : sentence;
        try {
            sentence2 = new CNFTransformer().transform(sentence4);
        }
        catch (Exception exception) {
            System.out.println("error converting kb +  query to CNF" + exception.getMessage());
        }
        return new DPLL().dpllSatisfiable(sentence2);
    }

    public boolean askWithTTEntails(String string) {
        return new TTEntails().ttEntails(this, string);
    }

    public String toString() {
        if (this.sentences.size() == 0) {
            return "";
        }
        return this.asSentence().toString();
    }

    public List getSentences() {
        return this.sentences;
    }
}

