/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.UnarySentence;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.logic.propositional.visitors.SymbolClassifier;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.Converter;
import aima.util.LogicUtils;
import aima.util.SetOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DPLL {
    private static final Converter<Symbol> SYMBOL_CONVERTER = new Converter();

    public boolean dpllSatisfiable(Sentence sentence) {
        return this.dpllSatisfiable(sentence, new Model());
    }

    public boolean dpllSatisfiable(String string) {
        Sentence sentence = (Sentence)new PEParser().parse(string);
        return this.dpllSatisfiable(sentence, new Model());
    }

    public boolean dpllSatisfiable(Sentence sentence, Model model) {
        Set<Sentence> set = new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(sentence));
        List<Symbol> list = SYMBOL_CONVERTER.setToList(new SymbolCollector().getSymbolsIn(sentence));
        return this.dpll(set, list, model);
    }

    private boolean dpll(Set<Sentence> set, List list, Model model) {
        List<Sentence> list2 = new Converter<Sentence>().setToList(set);
        if (this.areAllClausesTrue(model, list2)) {
            return true;
        }
        if (this.isEvenOneClauseFalse(model, list2)) {
            return false;
        }
        SymbolValuePair symbolValuePair = this.findPureSymbolValuePair(list2, model, list);
        if (symbolValuePair.notNull()) {
            List list3 = (List)((ArrayList)list).clone();
            list3.remove(new Symbol(symbolValuePair.symbol.getValue()));
            Model model2 = model.extend(new Symbol(symbolValuePair.symbol.getValue()), (boolean)symbolValuePair.value);
            return this.dpll(set, list3, model2);
        }
        SymbolValuePair symbolValuePair2 = this.findUnitClause(list2, model, list);
        if (symbolValuePair2.notNull()) {
            List list4 = (List)((ArrayList)list).clone();
            list4.remove(new Symbol(symbolValuePair2.symbol.getValue()));
            Model model3 = model.extend(new Symbol(symbolValuePair2.symbol.getValue()), (boolean)symbolValuePair2.value);
            return this.dpll(set, list4, model3);
        }
        Symbol symbol = (Symbol)list.get(0);
        List list5 = (List)((ArrayList)list).clone();
        list5.remove(0);
        return this.dpll(set, list5, model.extend(symbol, true)) || this.dpll(set, list5, model.extend(symbol, false));
    }

    private boolean isEvenOneClauseFalse(Model model, List list) {
        for (int i = 0; i < list.size(); ++i) {
            Sentence sentence = (Sentence)list.get(i);
            if (!model.isFalse(sentence)) continue;
            return true;
        }
        return false;
    }

    private boolean areAllClausesTrue(Model model, List list) {
        for (int i = 0; i < list.size(); ++i) {
            Sentence sentence = (Sentence)list.get(i);
            if (this.isClauseTrueInModel(sentence, model)) continue;
            return false;
        }
        return true;
    }

    private boolean isClauseTrueInModel(Sentence sentence, Model model) {
        List<Symbol> list = SYMBOL_CONVERTER.setToList(new SymbolClassifier().getPositiveSymbolsIn(sentence));
        List<Symbol> list2 = SYMBOL_CONVERTER.setToList(new SymbolClassifier().getNegativeSymbolsIn(sentence));
        for (Symbol symbol : list) {
            if (!model.isTrue(symbol)) continue;
            return true;
        }
        for (Symbol symbol : list2) {
            if (!model.isFalse(symbol)) continue;
            return true;
        }
        return false;
    }

    public List<Sentence> clausesWithNonTrueValues(List<Sentence> list, Model model) {
        ArrayList<Sentence> arrayList = new ArrayList<Sentence>();
        for (int i = 0; i < list.size(); ++i) {
            Sentence sentence = list.get(i);
            if (this.isClauseTrueInModel(sentence, model) || arrayList.contains(sentence)) continue;
            arrayList.add(sentence);
        }
        return arrayList;
    }

    public SymbolValuePair findPureSymbolValuePair(List<Sentence> list, Model model, List list2) {
        List<Sentence> list3 = this.clausesWithNonTrueValues(list, model);
        Sentence sentence = LogicUtils.chainWith("AND", list3);
        Set<Symbol> set = model.getAssignedSymbols();
        List<Symbol> list4 = SYMBOL_CONVERTER.setToList(new SetOps<Symbol>().difference(new SymbolClassifier().getPurePositiveSymbolsIn(sentence), set));
        List<Symbol> list5 = SYMBOL_CONVERTER.setToList(new SetOps<Symbol>().difference(new SymbolClassifier().getPureNegativeSymbolsIn(sentence), set));
        if (list4.size() == 0 && list5.size() == 0) {
            return new SymbolValuePair();
        }
        if (list4.size() > 0) {
            Symbol symbol = new Symbol(list4.get(0).getValue());
            if (list5.contains(symbol)) {
                throw new RuntimeException("Symbol " + symbol.getValue() + "misclassified");
            }
            return new SymbolValuePair(symbol, true);
        }
        Symbol symbol = new Symbol(list5.get(0).getValue());
        if (list4.contains(symbol)) {
            throw new RuntimeException("Symbol " + symbol.getValue() + "misclassified");
        }
        return new SymbolValuePair(symbol, false);
    }

    private SymbolValuePair findUnitClause(List list, Model model, List list2) {
        for (int i = 0; i < list.size(); ++i) {
            UnarySentence unarySentence;
            Sentence sentence;
            Sentence sentence2 = (Sentence)list.get(i);
            if (sentence2 instanceof Symbol && !model.getAssignedSymbols().contains(sentence2)) {
                return new SymbolValuePair(new Symbol(((Symbol)sentence2).getValue()), true);
            }
            if (!(sentence2 instanceof UnarySentence) || !((sentence = (unarySentence = (UnarySentence)sentence2).getNegated()) instanceof Symbol) || model.getAssignedSymbols().contains(sentence)) continue;
            return new SymbolValuePair(new Symbol(((Symbol)sentence).getValue()), false);
        }
        return new SymbolValuePair();
    }

    public class SymbolValuePair {
        public Symbol symbol;
        public Boolean value;

        public SymbolValuePair() {
            this.symbol = null;
            this.value = null;
        }

        public SymbolValuePair(Symbol symbol, boolean bl) {
            this.symbol = symbol;
            this.value = new Boolean(bl);
        }

        public boolean notNull() {
            return this.symbol != null && this.value != null;
        }

        public String toString() {
            String string = this.symbol == null ? "NULL" : this.symbol.toString();
            String string2 = this.value == null ? "NULL" : this.value.toString();
            return string + " -> " + string2;
        }
    }
}

