/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing.ast;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.Sentence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NotSentence
implements Sentence {
    private Sentence negated;
    private List<Sentence> args = new ArrayList<Sentence>();
    private String stringRep = null;
    private int hashCode = 0;

    public NotSentence(Sentence sentence) {
        this.negated = sentence;
        this.args.add(sentence);
    }

    public Sentence getNegated() {
        return this.negated;
    }

    @Override
    public String getSymbolicName() {
        return "NOT";
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    public List<Sentence> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public Object accept(FOLVisitor fOLVisitor, Object object) {
        return fOLVisitor.visitNotSentence(this, object);
    }

    @Override
    public NotSentence copy() {
        return new NotSentence(this.negated.copy());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NotSentence notSentence = (NotSentence)object;
        return notSentence.negated.equals(this.negated);
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.negated.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("NOT(");
            stringBuilder.append(this.negated.toString());
            stringBuilder.append(")");
            this.stringRep = stringBuilder.toString();
        }
        return this.stringRep;
    }
}

