/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.List;

public class AbstractFOLVisitor
implements FOLVisitor {
    protected Sentence recreate(Object object) {
        return ((Sentence)object).copy();
    }

    @Override
    public Object visitVariable(Variable variable, Object object) {
        return variable.copy();
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence quantifiedSentence, Object object) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (Variable variable : quantifiedSentence.getVariables()) {
            arrayList.add((Variable)variable.accept(this, object));
        }
        return new QuantifiedSentence(quantifiedSentence.getQuantifier(), arrayList, (Sentence)quantifiedSentence.getQuantified().accept(this, object));
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object object) {
        List<Term> list = predicate.getTerms();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (int i = 0; i < list.size(); ++i) {
            Term term = list.get(i);
            Term term2 = (Term)term.accept(this, object);
            arrayList.add(term2);
        }
        return new Predicate(predicate.getPredicateName(), arrayList);
    }

    @Override
    public Object visitTermEquality(TermEquality termEquality, Object object) {
        Term term = (Term)termEquality.getTerm1().accept(this, object);
        Term term2 = (Term)termEquality.getTerm2().accept(this, object);
        return new TermEquality(term, term2);
    }

    @Override
    public Object visitConstant(Constant constant, Object object) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object object) {
        List<Term> list = function.getTerms();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (int i = 0; i < list.size(); ++i) {
            Term term = list.get(i);
            Term term2 = (Term)term.accept(this, object);
            arrayList.add(term2);
        }
        return new Function(function.getFunctionName(), arrayList);
    }

    @Override
    public Object visitNotSentence(NotSentence notSentence, Object object) {
        return new NotSentence((Sentence)notSentence.getNegated().accept(this, object));
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence connectedSentence, Object object) {
        Sentence sentence = (Sentence)connectedSentence.getFirst().accept(this, object);
        Sentence sentence2 = (Sentence)connectedSentence.getSecond().accept(this, object);
        return new ConnectedSentence(connectedSentence.getConnector(), sentence, sentence2);
    }
}

