/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.kb;

import aima.logic.fol.CNFConverter;
import aima.logic.fol.StandardizeApart;
import aima.logic.fol.StandardizeApartIndexical;
import aima.logic.fol.StandardizeApartIndexicalFactory;
import aima.logic.fol.StandardizeApartResult;
import aima.logic.fol.SubstVisitor;
import aima.logic.fol.Unifier;
import aima.logic.fol.VariableCollector;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.inference.FOLOTTERLikeTheoremProver;
import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofStepClauseClausifySentence;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.kb.data.Chain;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.FOLNode;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FOLKnowledgeBase {
    private FOLParser parser;
    private InferenceProcedure inferenceProcedure;
    private Unifier unifier;
    private SubstVisitor substVisitor;
    private VariableCollector variableCollector;
    private StandardizeApart standardizeApart;
    private CNFConverter cnfConverter;
    private List<Sentence> originalSentences = new ArrayList<Sentence>();
    private Set<Clause> clauses = new LinkedHashSet<Clause>();
    private List<Clause> allDefiniteClauses = new ArrayList<Clause>();
    private List<Clause> implicationDefiniteClauses = new ArrayList<Clause>();
    private Map<String, List<Literal>> indexFacts = new HashMap<String, List<Literal>>();
    private StandardizeApartIndexical variableIndexical = StandardizeApartIndexicalFactory.newStandardizeApartIndexical(Character.valueOf('v'));
    private StandardizeApartIndexical queryIndexical = StandardizeApartIndexicalFactory.newStandardizeApartIndexical(Character.valueOf('q'));

    public FOLKnowledgeBase(FOLDomain fOLDomain) {
        this(fOLDomain, new FOLOTTERLikeTheoremProver());
    }

    public FOLKnowledgeBase(FOLDomain fOLDomain, InferenceProcedure inferenceProcedure) {
        this(fOLDomain, inferenceProcedure, new Unifier());
    }

    public FOLKnowledgeBase(FOLDomain fOLDomain, InferenceProcedure inferenceProcedure, Unifier unifier) {
        this.parser = new FOLParser(new FOLDomain(fOLDomain));
        this.inferenceProcedure = inferenceProcedure;
        this.unifier = unifier;
        this.substVisitor = new SubstVisitor();
        this.variableCollector = new VariableCollector();
        this.standardizeApart = new StandardizeApart(this.variableCollector, this.substVisitor);
        this.cnfConverter = new CNFConverter(this.parser);
    }

    public void clear() {
        this.originalSentences.clear();
        this.clauses.clear();
        this.allDefiniteClauses.clear();
        this.implicationDefiniteClauses.clear();
        this.indexFacts.clear();
    }

    public InferenceProcedure getInferenceProcedure() {
        return this.inferenceProcedure;
    }

    public void setInferenceProcedure(InferenceProcedure inferenceProcedure) {
        if (null != inferenceProcedure) {
            this.inferenceProcedure = inferenceProcedure;
        }
    }

    public Sentence tell(String string) {
        Sentence sentence = this.parser.parse(string);
        this.tell(sentence);
        return sentence;
    }

    public void tell(List<? extends Sentence> list) {
        for (Sentence sentence : list) {
            this.tell(sentence);
        }
    }

    public void tell(Sentence sentence) {
        this.store(sentence);
    }

    public InferenceResult ask(String string) {
        return this.ask(this.parser.parse(string));
    }

    public InferenceResult ask(Sentence sentence) {
        StandardizeApartResult standardizeApartResult = this.standardizeApart.standardizeApart(sentence, this.queryIndexical);
        InferenceResult inferenceResult = this.getInferenceProcedure().ask(this, standardizeApartResult.getStandardized());
        for (Proof proof : inferenceResult.getProofs()) {
            Map<Variable, Term> map = proof.getAnswerBindings();
            LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
            for (Variable variable : standardizeApartResult.getReverseSubstitution().keySet()) {
                linkedHashMap.put((Variable)standardizeApartResult.getReverseSubstitution().get(variable), map.get(variable));
            }
            proof.replaceAnswerBindings(linkedHashMap);
        }
        return inferenceResult;
    }

    public int getNumberFacts() {
        return this.allDefiniteClauses.size() - this.implicationDefiniteClauses.size();
    }

    public int getNumberRules() {
        return this.clauses.size() - this.getNumberFacts();
    }

    public List<Sentence> getOriginalSentences() {
        return Collections.unmodifiableList(this.originalSentences);
    }

    public List<Clause> getAllDefiniteClauses() {
        return Collections.unmodifiableList(this.allDefiniteClauses);
    }

    public List<Clause> getAllDefiniteClauseImplications() {
        return Collections.unmodifiableList(this.implicationDefiniteClauses);
    }

    public Set<Clause> getAllClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    public synchronized Set<Map<Variable, Term>> fetch(Literal literal) {
        LinkedHashSet<Map<Variable, Term>> linkedHashSet = new LinkedHashSet<Map<Variable, Term>>();
        List<Literal> list = this.fetchMatchingFacts(literal);
        if (null != list) {
            for (Literal literal2 : list) {
                Map<Variable, Term> map = this.unifier.unify(literal.getAtomicSentence(), literal2.getAtomicSentence());
                if (null == map) continue;
                linkedHashSet.add(map);
            }
        }
        return linkedHashSet;
    }

    public Set<Map<Variable, Term>> fetch(List<Literal> list) {
        LinkedHashSet<Map<Variable, Term>> linkedHashSet = new LinkedHashSet<Map<Variable, Term>>();
        if (list.size() > 0) {
            Literal literal = list.get(0);
            List<Literal> list2 = list.subList(1, list.size());
            this.recursiveFetch(new LinkedHashMap<Variable, Term>(), literal, list2, linkedHashSet);
        }
        return linkedHashSet;
    }

    public Map<Variable, Term> unify(FOLNode fOLNode, FOLNode fOLNode2) {
        return this.unifier.unify(fOLNode, fOLNode2);
    }

    public Sentence subst(Map<Variable, Term> map, Sentence sentence) {
        return this.substVisitor.subst(map, sentence);
    }

    public Literal subst(Map<Variable, Term> map, Literal literal) {
        return this.substVisitor.subst(map, literal);
    }

    public Term subst(Map<Variable, Term> map, Term term) {
        return this.substVisitor.subst(map, term);
    }

    public Sentence standardizeApart(Sentence sentence) {
        return this.standardizeApart.standardizeApart(sentence, this.variableIndexical).getStandardized();
    }

    public Clause standardizeApart(Clause clause) {
        return this.standardizeApart.standardizeApart(clause, this.variableIndexical);
    }

    public Chain standardizeApart(Chain chain) {
        return this.standardizeApart.standardizeApart(chain, this.variableIndexical);
    }

    public Set<Variable> collectAllVariables(Sentence sentence) {
        return this.variableCollector.collectAllVariables(sentence);
    }

    public CNF convertToCNF(Sentence sentence) {
        return this.cnfConverter.convertToCNF(sentence);
    }

    public Set<Clause> convertToClauses(Sentence sentence) {
        CNF cNF = this.cnfConverter.convertToCNF(sentence);
        return new LinkedHashSet<Clause>(cNF.getConjunctionOfClauses());
    }

    public Literal createAnswerLiteral(Sentence sentence) {
        String string = this.parser.getFOLDomain().addAnswerLiteral();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Set<Variable> set = this.variableCollector.collectAllVariables(sentence);
        for (Variable variable : set) {
            arrayList.add(variable.copy());
        }
        return new Literal(new Predicate(string, arrayList));
    }

    public boolean isRenaming(Literal literal) {
        List<Literal> list = this.fetchMatchingFacts(literal);
        if (null != list) {
            return this.isRenaming(literal, list);
        }
        return false;
    }

    public boolean isRenaming(Literal literal, List<Literal> list) {
        for (Literal literal2 : list) {
            Map<Variable, Term> map;
            if (literal.isPositiveLiteral() != literal2.isPositiveLiteral() || null == (map = this.unifier.unify(literal.getAtomicSentence(), literal2.getAtomicSentence()))) continue;
            int n = 0;
            for (Term term : map.values()) {
                if (!(term instanceof Variable)) continue;
                ++n;
            }
            if (map.size() != n) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Sentence sentence : this.originalSentences) {
            stringBuilder.append(sentence.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    protected FOLParser getParser() {
        return this.parser;
    }

    private synchronized void store(Sentence sentence) {
        this.originalSentences.add(sentence);
        CNF cNF = this.cnfConverter.convertToCNF(sentence);
        for (Clause clause : cNF.getConjunctionOfClauses()) {
            clause.setProofStep(new ProofStepClauseClausifySentence(clause, sentence));
            if (clause.isEmpty()) {
                throw new IllegalArgumentException("Attempted to add unsatisfiable sentence to KB, orig=[" + sentence + "] CNF=" + cNF);
            }
            clause = this.standardizeApart.standardizeApart(clause, this.variableIndexical);
            clause.setImmutable();
            if (!this.clauses.add(clause)) continue;
            if (clause.isDefiniteClause()) {
                this.allDefiniteClauses.add(clause);
            }
            if (clause.isImplicationDefiniteClause()) {
                this.implicationDefiniteClauses.add(clause);
            }
            if (!clause.isUnitClause()) continue;
            this.indexFact(clause.getLiterals().iterator().next());
        }
    }

    private void indexFact(Literal literal) {
        String string = this.getFactKey(literal);
        if (!this.indexFacts.containsKey(string)) {
            this.indexFacts.put(string, new ArrayList());
        }
        this.indexFacts.get(string).add(literal);
    }

    private void recursiveFetch(Map<Variable, Term> map, Literal literal, List<Literal> list, Set<Map<Variable, Term>> set) {
        Set<Map<Variable, Term>> set2 = this.fetch(this.subst(map, literal));
        if (null == set2) {
            return;
        }
        for (Map<Variable, Term> map2 : set2) {
            map2.putAll(map);
            if (list.size() == 0) {
                set.add(map2);
                continue;
            }
            Literal literal2 = list.get(0);
            List<Literal> list2 = list.subList(1, list.size());
            this.recursiveFetch(map2, literal2, list2, set);
        }
    }

    private List<Literal> fetchMatchingFacts(Literal literal) {
        return this.indexFacts.get(this.getFactKey(literal));
    }

    private String getFactKey(Literal literal) {
        StringBuilder stringBuilder = new StringBuilder();
        if (literal.isPositiveLiteral()) {
            stringBuilder.append("+");
        } else {
            stringBuilder.append("-");
        }
        stringBuilder.append(literal.getAtomicSentence().getSymbolicName());
        return stringBuilder.toString();
    }
}

