/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.neural;

import aima.learning.framework.DataSet;
import aima.learning.framework.Example;
import aima.learning.neural.NNExample;
import aima.learning.neural.Numerizer;
import aima.util.Pair;
import aima.util.Util;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class NNDataSet {
    private List<NNExample> dataset;
    private List<NNExample> presentlyProcessed = new ArrayList<NNExample>();
    private List<Double> means;
    private List<Double> stdevs;
    protected List<List<Double>> nds;
    protected List<Integer> targetColumnNumbers;

    public abstract void setTargetColumns();

    private void createExamples() {
        this.dataset = new ArrayList<NNExample>();
        for (List<Double> list : this.nds) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (int i = 0; i < list.size(); ++i) {
                if (this.targetColumnNumbers.contains(i)) {
                    arrayList2.add(list.get(i));
                    continue;
                }
                arrayList.add(list.get(i));
            }
            this.dataset.add(new NNExample(arrayList, arrayList2));
        }
        this.refreshDataset();
    }

    public void createNormalizedDataFromFile(String string) throws Exception {
        String string2;
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("../data/" + string + ".csv")));
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(this.exampleFromString(string2, ","));
        }
        this.nds = this.normalize(arrayList);
    }

    public void createNormalizedDataFromDataSet(DataSet dataSet, Numerizer numerizer) throws Exception {
        List<List<Double>> list = this.rawExamplesFromDataSet(dataSet, numerizer);
        this.nds = this.normalize(list);
    }

    private List<List<Double>> normalize(List<List<Double>> list) {
        int n;
        int n2 = list.get(0).size();
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        this.means = new ArrayList<Double>();
        this.stdevs = new ArrayList<Double>();
        ArrayList<List<Double>> arrayList2 = new ArrayList<List<Double>>();
        for (n = 0; n < n2; ++n) {
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            for (List<Double> list2 : list) {
                arrayList3.add(list2.get(n));
            }
            double d = Util.calculateMean(arrayList3);
            this.means.add(d);
            double d2 = Util.calculateStDev(arrayList3, d);
            this.stdevs.add(d2);
            arrayList2.add(Util.normalizeFromMeanAndStdev(arrayList3, d, d2));
        }
        n = ((List)arrayList2.get(0)).size();
        int n3 = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            List<Double> list2;
            list2 = new ArrayList<Double>();
            for (int j = 0; j < n3; ++j) {
                list2.add((Double)((List)arrayList2.get(j)).get(i));
            }
            arrayList.add(list2);
        }
        return arrayList;
    }

    private List<Double> exampleFromString(String string, String string2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        List<String> list = Arrays.asList(string.split(string2));
        for (String string3 : list) {
            arrayList.add(Double.parseDouble(string3));
        }
        return arrayList;
    }

    private List<List<Double>> rawExamplesFromDataSet(DataSet dataSet, Numerizer numerizer) {
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        for (int i = 0; i < dataSet.size(); ++i) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            Example example = dataSet.getExample(i);
            Pair<List<Double>, List<Double>> pair = numerizer.numerize(example);
            List<Double> list = pair.getFirst();
            for (Double d : list) {
                arrayList2.add(d);
            }
            List<Double> list2 = pair.getSecond();
            Iterator object2 = list2.iterator();
            while (object2.hasNext()) {
                Double d = (Double)object2.next();
                arrayList2.add(d);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public NNExample getExampleAtRandom() {
        int n = Util.randomNumberBetween(0, this.presentlyProcessed.size() - 1);
        return this.presentlyProcessed.remove(n);
    }

    public NNExample getExample(int n) {
        return this.presentlyProcessed.remove(n);
    }

    public boolean hasMoreExamples() {
        return this.presentlyProcessed.size() > 0;
    }

    public int howManyExamplesLeft() {
        return this.presentlyProcessed.size();
    }

    public void refreshDataset() {
        this.presentlyProcessed = new ArrayList<NNExample>();
        for (NNExample nNExample : this.dataset) {
            this.presentlyProcessed.add(nNExample.copyExample());
        }
    }

    public void createExamplesFromFile(String string) throws Exception {
        this.createNormalizedDataFromFile(string);
        this.setTargetColumns();
        this.createExamples();
    }

    public void createExamplesFromDataSet(DataSet dataSet, Numerizer numerizer) throws Exception {
        this.createNormalizedDataFromDataSet(dataSet, numerizer);
        this.setTargetColumns();
        this.createExamples();
    }

    public List<List<Double>> getNormalizedData() {
        return this.nds;
    }

    public List<Double> getMeans() {
        return this.means;
    }

    public List<Double> getStdevs() {
        return this.stdevs;
    }
}

