/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.knowledge;

import aima.learning.framework.Example;
import aima.learning.knowledge.FOLDataSetDomain;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import java.util.ArrayList;

public class FOLExample {
    private FOLDataSetDomain folDSDomain = null;
    private Example example = null;
    private int egNo = 0;
    private Constant ithExampleConstant = null;
    private Sentence classification = null;
    private Sentence description = null;

    public FOLExample(FOLDataSetDomain fOLDataSetDomain, Example example, int n) {
        this.folDSDomain = fOLDataSetDomain;
        this.example = example;
        this.egNo = n;
        this.constructFOLEg();
    }

    public int getExampleNumber() {
        return this.egNo;
    }

    public Sentence getClassification() {
        return this.classification;
    }

    public Sentence getDescription() {
        return this.description;
    }

    public String toString() {
        return this.classification.toString() + " " + "AND" + " " + this.description.toString();
    }

    private void constructFOLEg() {
        this.ithExampleConstant = new Constant(this.folDSDomain.getExampleConstant(this.egNo));
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(this.ithExampleConstant);
        this.classification = new Predicate(this.folDSDomain.getGoalPredicateName(), arrayList);
        if (!this.example.getAttributeValueAsString(this.folDSDomain.getDataSetTargetName()).equals(this.folDSDomain.getTrueGoalValue())) {
            this.classification = new NotSentence(this.classification);
        }
        ArrayList<Predicate> arrayList2 = new ArrayList<Predicate>();
        for (String string : this.folDSDomain.getDescriptionDataSetNames()) {
            String string2 = this.folDSDomain.getFOLName(string);
            arrayList = new ArrayList();
            arrayList.add(this.ithExampleConstant);
            Sentence sentence = null;
            if (this.folDSDomain.isMultivalued(string)) {
                arrayList.add(new Constant(this.folDSDomain.getFOLName(this.example.getAttributeValueAsString(string))));
                sentence = new Predicate(string2, arrayList);
            } else {
                sentence = new Predicate(string2, arrayList);
                if (!this.folDSDomain.getTrueGoalValue().equals(this.example.getAttributeValueAsString(string))) {
                    sentence = new NotSentence(sentence);
                }
            }
            arrayList2.add((Predicate)sentence);
        }
        if (arrayList2.size() == 1) {
            this.description = (Sentence)arrayList2.get(0);
        } else if (arrayList2.size() > 1) {
            this.description = new ConnectedSentence("AND", (Sentence)arrayList2.get(0), (Sentence)arrayList2.get(1));
            for (int i = 2; i < arrayList2.size(); ++i) {
                this.description = new ConnectedSentence("AND", this.description, (Sentence)arrayList2.get(i));
            }
        }
    }
}

