/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.inductive;

import aima.learning.framework.DataSet;
import aima.learning.framework.Example;
import aima.learning.inductive.ConstantDecisonTree;
import aima.util.Util;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DecisionTree {
    private String attributeName;
    private Hashtable<String, DecisionTree> nodes;

    protected DecisionTree() {
    }

    public DecisionTree(String string) {
        this.attributeName = string;
        this.nodes = new Hashtable();
    }

    public void addLeaf(String string, String string2) {
        this.nodes.put(string, new ConstantDecisonTree(string2));
    }

    public void addNode(String string, DecisionTree decisionTree) {
        this.nodes.put(string, decisionTree);
    }

    public Object predict(Example example) {
        String string = example.getAttributeValueAsString(this.attributeName);
        if (this.nodes.containsKey(string)) {
            return this.nodes.get(string).predict(example);
        }
        throw new RuntimeException("no node exists for attribute value " + string);
    }

    public static DecisionTree getStumpFor(DataSet dataSet, String string, String string2, String string3, List<String> list, String string4) {
        DecisionTree decisionTree = new DecisionTree(string);
        decisionTree.addLeaf(string2, string3);
        for (String string5 : list) {
            decisionTree.addLeaf(string5, string4);
        }
        return decisionTree;
    }

    public static List<DecisionTree> getStumpsFor(DataSet dataSet, String string, String string2) {
        List<String> list = dataSet.getNonTargetAttributes();
        ArrayList<DecisionTree> arrayList = new ArrayList<DecisionTree>();
        for (String string3 : list) {
            List<String> list2 = dataSet.getPossibleAttributeValues(string3);
            for (String string4 : list2) {
                List<String> list3 = Util.removeFrom(dataSet.getPossibleAttributeValues(string3), string4);
                DecisionTree decisionTree = DecisionTree.getStumpFor(dataSet, string3, string4, string, list3, string2);
                arrayList.add(decisionTree);
            }
        }
        return arrayList;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        return this.toString(1, new StringBuffer());
    }

    public String toString(int n, StringBuffer stringBuffer) {
        if (this.attributeName != null) {
            stringBuffer.append(Util.ntimes("\t", n));
            stringBuffer.append(Util.ntimes("***", 1));
            stringBuffer.append(this.attributeName + " \n");
            for (String string : this.nodes.keySet()) {
                stringBuffer.append(Util.ntimes("\t", n + 1));
                stringBuffer.append("+" + string);
                stringBuffer.append("\n");
                DecisionTree decisionTree = this.nodes.get(string);
                stringBuffer.append(decisionTree.toString(n + 1, new StringBuffer()));
            }
        }
        return stringBuffer.toString();
    }
}

