/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications.search.map;

import aima.basic.Agent;
import aima.gui.framework.AgentAppModel;
import aima.search.map.Map;
import aima.search.map.Point2D;
import aima.search.map.Scenario;
import java.util.ArrayList;
import java.util.List;

public class MapAgentModel
extends AgentAppModel {
    protected Scenario scenario;
    protected List<String> destinations;
    private final ArrayList<String> tourHistory = new ArrayList();

    public List<String> getTourHistory() {
        return this.tourHistory;
    }

    public void clearTourHistory() {
        this.tourHistory.clear();
    }

    @Override
    public void envChanged(String string) {
        for (AgentAppModel.ModelChangedListener modelChangedListener : this.listeners) {
            modelChangedListener.logMessage(string);
        }
        if (this.getLocCoords(string) != null || string.equals("NoOP")) {
            String string2 = (String)this.getAgent().getAttribute("location");
            this.tourHistory.add(string2);
            this.fireModelChanged();
        }
    }

    public void prepare(Scenario scenario, List<String> list) {
        this.scenario = scenario;
        this.destinations = list;
        this.clearTourHistory();
        this.fireModelChanged();
    }

    public boolean isEmpty() {
        return this.scenario == null;
    }

    public List<String> getLocations() {
        List<String> list = this.scenario.getEnvMap().getLocations();
        if (!list.containsAll(this.scenario.getAgentMap().getLocations())) {
            list = new ArrayList<String>(list);
            for (String string : this.scenario.getAgentMap().getLocations()) {
                if (list.contains(string)) continue;
                list.add(string);
            }
        }
        return list;
    }

    public Map getAgentMap() {
        return this.scenario.getAgentMap();
    }

    public Map getEnvMap() {
        return this.scenario.getEnvMap();
    }

    public Agent getAgent() {
        return (Agent)this.scenario.getEnv().getAgents().get(0);
    }

    public boolean isStart(String string) {
        return this.scenario.getInitAgentLocation() == string;
    }

    public boolean isDestination(String string) {
        return this.destinations != null && this.destinations.contains(string);
    }

    public Point2D getLocCoords(String string) {
        return this.scenario.getEnvMap().getPosition(string);
    }

    public boolean hasInfos(String string) {
        return false;
    }

    public boolean hasObjects(String string) {
        return false;
    }
}

