/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom.shapes;

import aima.core.util.Util;

public final class Vector2D {
    public static final Vector2D X_VECTOR = new Vector2D(1.0, 0.0);
    public static final Vector2D Y_VECTOR = new Vector2D(0.0, 1.0);
    public static final Vector2D ZERO_VECTOR = new Vector2D(0.0, 0.0);
    private final double x;
    private final double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Vector2D calculateFromPolar(double length, double heading) {
        double x = length * Math.cos(heading);
        double y = length * Math.sin(heading);
        return new Vector2D(x, y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Vector2D add(Vector2D op2) {
        return new Vector2D(this.x + op2.x, this.y + op2.y);
    }

    public Vector2D sub(Vector2D op2) {
        return new Vector2D(this.x - op2.x, this.y - op2.y);
    }

    public Vector2D multiply(double n) {
        return new Vector2D(this.x * n, this.y * n);
    }

    public Vector2D invert() {
        return new Vector2D(-this.x, -this.y);
    }

    public boolean isAbsoluteParallel(Vector2D op2) {
        return this.y * op2.getX() - this.x * op2.getY() == 0.0;
    }

    public boolean isParallel(Vector2D op2) {
        double angle = this.angleTo(op2);
        return Util.compareDoubles(angle, 0.0) || Util.compareDoubles(angle, Math.PI);
    }

    public double angleTo(Vector2D op2) {
        double result = Math.atan2(op2.getY(), op2.getX()) - Math.atan2(this.y, this.x);
        return result < 0.0 ? result + Math.PI * 2 : result;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public boolean equals(Vector2D op2) {
        if (op2 == null) {
            return false;
        }
        return Util.compareDoubles(this.x, op2.x) && Util.compareDoubles(this.y, op2.y);
    }

    public boolean equals(Object o) {
        if (o instanceof Vector2D) {
            return this.equals((Vector2D)o);
        }
        return false;
    }
}

