/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom.shapes;

import aima.core.util.Util;
import aima.core.util.math.geom.shapes.Point2D;

public class TransformMatrix2D {
    public static final TransformMatrix2D UNITY_MATRIX = new TransformMatrix2D(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double e;
    private final double f;

    private TransformMatrix2D(double a, double b, double c, double d, double e, double f) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        this.f = f;
    }

    public static TransformMatrix2D translate(double x, double y) {
        return new TransformMatrix2D(1.0, 0.0, 0.0, 1.0, x, y);
    }

    public static TransformMatrix2D scale(double x, double y) {
        return new TransformMatrix2D(x, 0.0, 0.0, y, 0.0, 0.0);
    }

    public static TransformMatrix2D rotate(double alpha) {
        double sin = Math.sin(alpha);
        double cos = Math.cos(alpha);
        return new TransformMatrix2D(cos, sin, -sin, cos, 0.0, 0.0);
    }

    public TransformMatrix2D multiply(TransformMatrix2D matrix) {
        return new TransformMatrix2D(this.a * matrix.a + this.c * matrix.b, this.b * matrix.a + this.d * matrix.b, this.a * matrix.c + this.c * matrix.d, this.b * matrix.c + this.d * matrix.d, this.a * matrix.e + this.c * matrix.f + this.e, this.b * matrix.e + this.d * matrix.f + this.f);
    }

    public double determinant() {
        return this.a * this.d - this.b * this.c;
    }

    public TransformMatrix2D inverse() {
        if (this == UNITY_MATRIX) {
            return UNITY_MATRIX;
        }
        double determinant = this.determinant();
        if (determinant == 0.0) {
            return null;
        }
        return new TransformMatrix2D(this.d / determinant, -this.b / determinant, -this.c / determinant, this.a / determinant, (this.c * this.f - this.d * this.e) / determinant, (this.b * this.e - this.a * this.f) / determinant);
    }

    public Point2D multiply(Point2D point) {
        double xNew = point.getX() * this.a + point.getY() * this.c + this.e;
        double yNew = point.getX() * this.b + point.getY() * this.d + this.f;
        return new Point2D(xNew, yNew);
    }

    public boolean equals(TransformMatrix2D op2) {
        if (op2 == null) {
            return false;
        }
        return Util.compareDoubles(this.a, op2.a) && Util.compareDoubles(this.b, op2.b) && Util.compareDoubles(this.c, op2.c) && Util.compareDoubles(this.d, op2.d) && Util.compareDoubles(this.e, op2.e) && Util.compareDoubles(this.f, op2.f);
    }

    public boolean equals(Object o) {
        if (o instanceof TransformMatrix2D) {
            return this.equals((TransformMatrix2D)o);
        }
        return false;
    }
}

