/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom.shapes;

import aima.core.util.Util;
import aima.core.util.math.geom.shapes.IGeometric2D;
import aima.core.util.math.geom.shapes.Point2D;
import aima.core.util.math.geom.shapes.Polyline2D;
import aima.core.util.math.geom.shapes.Ray2D;
import aima.core.util.math.geom.shapes.TransformMatrix2D;
import aima.core.util.math.geom.shapes.Vector2D;

public final class Rect2D
implements IGeometric2D {
    private final Vector2D horizontalVector;
    private final Vector2D verticalVector;
    private final Point2D lowerLeft;
    private final Point2D upperRight;
    private final Point2D lowerRight;
    private final Point2D upperLeft;

    public Rect2D(Point2D lowerLeft, Point2D upperRight) {
        this(lowerLeft.getX(), lowerLeft.getY(), upperRight.getX(), upperRight.getY());
    }

    public Rect2D(double x1, double y1, double x2, double y2) {
        if (x1 < x2) {
            if (y1 < y2) {
                this.lowerLeft = new Point2D(x1, y1);
                this.upperRight = new Point2D(x2, y2);
            } else {
                this.lowerLeft = new Point2D(x1, y2);
                this.upperRight = new Point2D(x2, y1);
            }
        } else if (y1 < y2) {
            this.lowerLeft = new Point2D(x2, y1);
            this.upperRight = new Point2D(x1, y2);
        } else {
            this.lowerLeft = new Point2D(x2, y2);
            this.upperRight = new Point2D(x1, y1);
        }
        this.lowerRight = new Point2D(this.upperRight.getX(), this.lowerLeft.getY());
        this.upperLeft = new Point2D(this.lowerLeft.getX(), this.upperRight.getY());
        this.horizontalVector = new Vector2D(this.lowerRight.getX() - this.lowerLeft.getX(), 0.0);
        this.verticalVector = new Vector2D(0.0, this.upperLeft.getY() - this.lowerLeft.getY());
    }

    public Point2D getLowerLeft() {
        return this.lowerLeft;
    }

    public Point2D getUpperRight() {
        return this.upperRight;
    }

    public Point2D getLowerRight() {
        return this.lowerRight;
    }

    public Point2D getUpperLeft() {
        return this.upperLeft;
    }

    @Override
    public Point2D randomPoint() {
        double x = Util.generateRandomDoubleBetween(this.lowerLeft.getX(), this.upperRight.getX());
        double y = Util.generateRandomDoubleBetween(this.lowerLeft.getY(), this.upperRight.getY());
        return new Point2D(x, y);
    }

    @Override
    public boolean isInside(Point2D point) {
        return this.lowerLeft.getX() < point.getX() && this.lowerLeft.getY() < point.getY() && this.upperRight.getX() > point.getX() && this.upperRight.getY() > point.getY();
    }

    @Override
    public boolean isInsideBorder(Point2D point) {
        return this.lowerLeft.getX() <= point.getX() && this.lowerLeft.getY() <= point.getY() && this.upperRight.getX() >= point.getX() && this.upperRight.getY() >= point.getY();
    }

    @Override
    public double rayCast(Ray2D ray) {
        double sideLen;
        double sideLen2;
        double divisor;
        double result = Double.POSITIVE_INFINITY;
        if (!Util.compareDoubles(ray.getDirection().getY(), 0.0) && !Util.compareDoubles(divisor = ray.getDirection().getY() * this.horizontalVector.getX(), 0.0)) {
            double rayLen2;
            double rayLen1 = (this.lowerLeft.getY() * this.horizontalVector.getX() - ray.getStart().getY() * this.horizontalVector.getX()) / divisor;
            if (rayLen1 > 0.0 && (sideLen2 = (ray.getDirection().getY() * ray.getStart().getX() - ray.getDirection().getY() * this.lowerLeft.getX() - ray.getDirection().getX() * ray.getStart().getY() + ray.getDirection().getX() * this.lowerLeft.getY()) / divisor) >= 0.0 && sideLen2 <= 1.0) {
                result = rayLen1;
            }
            if ((rayLen2 = (this.upperLeft.getY() * this.horizontalVector.getX() - ray.getStart().getY() * this.horizontalVector.getX()) / divisor) > 0.0 && (sideLen = (ray.getDirection().getY() * ray.getStart().getX() - ray.getDirection().getY() * this.upperLeft.getX() - ray.getDirection().getX() * ray.getStart().getY() + ray.getDirection().getX() * this.upperLeft.getY()) / divisor) >= 0.0 && sideLen <= 1.0) {
                double d = result = result > rayLen2 ? rayLen2 : result;
            }
        }
        if (!Util.compareDoubles(ray.getDirection().getX(), 0.0) && !Util.compareDoubles(divisor = -ray.getDirection().getX() * this.verticalVector.getY(), 0.0)) {
            double rayLen4;
            double rayLen3 = (-this.lowerLeft.getX() * this.verticalVector.getY() + ray.getStart().getX() * this.verticalVector.getY()) / divisor;
            if (rayLen3 > 0.0 && (sideLen2 = (ray.getDirection().getY() * ray.getStart().getX() - ray.getDirection().getY() * this.lowerLeft.getX() - ray.getDirection().getX() * ray.getStart().getY() + ray.getDirection().getX() * this.lowerLeft.getY()) / divisor) >= 0.0 && sideLen2 <= 1.0) {
                double d = result = result > rayLen3 ? rayLen3 : result;
            }
            if ((rayLen4 = (-this.lowerRight.getX() * this.verticalVector.getY() + ray.getStart().getX() * this.verticalVector.getY()) / divisor) > 0.0 && (sideLen = (ray.getDirection().getY() * ray.getStart().getX() - ray.getDirection().getY() * this.lowerRight.getX() - ray.getDirection().getX() * ray.getStart().getY() + ray.getDirection().getX() * this.lowerRight.getY()) / divisor) >= 0.0 && sideLen <= 1.0) {
                result = result > rayLen4 ? rayLen4 : result;
            }
        }
        return result * ray.getDirection().length();
    }

    @Override
    public Rect2D getBounds() {
        return this;
    }

    @Override
    public IGeometric2D transform(TransformMatrix2D matrix) {
        Point2D lowerLeftNew = matrix.multiply(this.lowerLeft);
        Point2D upperRightNew = matrix.multiply(this.upperRight);
        Point2D upperLeftNew = matrix.multiply(this.upperLeft);
        Point2D lowerRightNew = matrix.multiply(this.lowerRight);
        if (!(Util.compareDoubles(lowerLeftNew.getY(), lowerRightNew.getY()) && Util.compareDoubles(upperLeftNew.getY(), upperRightNew.getY()) && Util.compareDoubles(lowerLeftNew.getX(), upperLeftNew.getX()) && Util.compareDoubles(lowerRightNew.getX(), upperRightNew.getX()))) {
            Point2D[] vertexes = new Point2D[]{lowerLeftNew, lowerRightNew, upperRightNew, upperLeftNew};
            return new Polyline2D(vertexes, true);
        }
        return new Rect2D(lowerLeftNew, upperRightNew);
    }
}

