/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom.shapes;

import aima.core.util.math.geom.shapes.Point2D;
import aima.core.util.math.geom.shapes.TransformMatrix2D;
import aima.core.util.math.geom.shapes.Vector2D;

public final class Ray2D {
    private final Point2D start;
    private final Vector2D direction;

    public Ray2D(Point2D start, Vector2D direction) {
        this.start = start;
        this.direction = direction;
    }

    public Ray2D(double startX, double startY, double endX, double endY) {
        this.start = new Point2D(startX, startY);
        this.direction = new Vector2D(endX - startX, endY - startY);
    }

    public Point2D getStart() {
        return this.start;
    }

    public Vector2D getDirection() {
        return this.direction;
    }

    public Ray2D transform(TransformMatrix2D matrix) {
        Point2D startNew = matrix.multiply(this.start);
        Vector2D directionNew = startNew.vec(matrix.multiply(this.start.add(this.direction)));
        return new Ray2D(startNew, directionNew);
    }
}

