/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom.shapes;

import aima.core.util.Util;
import aima.core.util.math.geom.shapes.IGeometric2D;
import aima.core.util.math.geom.shapes.Line2D;
import aima.core.util.math.geom.shapes.Point2D;
import aima.core.util.math.geom.shapes.Ray2D;
import aima.core.util.math.geom.shapes.Rect2D;
import aima.core.util.math.geom.shapes.TransformMatrix2D;
import aima.core.util.math.geom.shapes.Vector2D;

public final class Polyline2D
implements IGeometric2D {
    private final Point2D[] vertexes;
    private final Vector2D[] edges;
    private final boolean isClosed;
    private final Rect2D boundingRect;

    public Polyline2D(Point2D[] vertexes, boolean isClosed) {
        this.vertexes = vertexes;
        this.isClosed = isClosed;
        int length = isClosed ? vertexes.length : vertexes.length - 1;
        this.edges = new Vector2D[length];
        Point2D previousPoint = vertexes[0];
        for (int i = 1; i < vertexes.length; ++i) {
            Point2D targetPoint = vertexes[i];
            this.edges[i - 1] = previousPoint.vec(targetPoint);
            previousPoint = targetPoint;
        }
        if (isClosed) {
            this.edges[vertexes.length - 1] = previousPoint.vec(vertexes[0]);
        }
        double minX = vertexes[0].getX();
        double minY = vertexes[0].getY();
        double maxX = vertexes[0].getX();
        double maxY = vertexes[0].getY();
        for (int i = 1; i < vertexes.length; ++i) {
            minX = minX > vertexes[i].getX() ? vertexes[i].getX() : minX;
            minY = minY > vertexes[i].getY() ? vertexes[i].getY() : minY;
            maxX = maxX < vertexes[i].getX() ? vertexes[i].getX() : maxX;
            maxY = maxY < vertexes[i].getY() ? vertexes[i].getY() : maxY;
        }
        this.boundingRect = new Rect2D(minX, minY, maxX, maxY);
    }

    public Point2D[] getVertexes() {
        return this.vertexes;
    }

    public Vector2D[] getEdges() {
        return this.edges;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Point2D randomPoint() {
        if (this.isClosed) {
            double minX = this.boundingRect.getUpperLeft().getX();
            double maxX = this.boundingRect.getLowerRight().getX();
            double minY = this.boundingRect.getUpperLeft().getY();
            double maxY = this.boundingRect.getLowerRight().getY();
            Point2D randPoint = new Point2D(Util.generateRandomDoubleBetween(minX, maxX), Util.generateRandomDoubleBetween(minY, maxY));
            while (!this.isInsideBorder(randPoint)) {
                randPoint = new Point2D(Util.generateRandomDoubleBetween(minX, maxX), Util.generateRandomDoubleBetween(minY, maxY));
            }
            return randPoint;
        }
        int index = Util.randomNumberBetween(0, this.vertexes.length - 2);
        Line2D line = new Line2D(this.vertexes[index], this.edges[index]);
        return line.randomPoint();
    }

    @Override
    public boolean isInside(Point2D point) {
        if (!this.isClosed) {
            return false;
        }
        int intersections = 0;
        Ray2D pointRay = new Ray2D(point, Vector2D.X_VECTOR);
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.vertexes[i].equals(point)) {
                return false;
            }
            double result = new Line2D(this.vertexes[i], this.edges[i]).rayCast(pointRay);
            if (Util.compareDoubles(result, Double.POSITIVE_INFINITY) || Util.compareDoubles(result, 0.0) || Util.compareDoubles(this.edges[i].angleTo(Vector2D.X_VECTOR), 0.0)) continue;
            ++intersections;
        }
        return intersections % 2 == 1;
    }

    @Override
    public boolean isInsideBorder(Point2D point) {
        int intersections = 0;
        Ray2D pointRay = new Ray2D(point, Vector2D.X_VECTOR);
        for (int i = 0; i < this.edges.length; ++i) {
            Line2D line = new Line2D(this.vertexes[i], this.edges[i]);
            if (line.isInsideBorder(point)) {
                return true;
            }
            double result = line.rayCast(pointRay);
            if (Util.compareDoubles(result, Double.POSITIVE_INFINITY) || !this.isClosed || Util.compareDoubles(this.edges[i].angleTo(Vector2D.X_VECTOR), 0.0)) continue;
            ++intersections;
        }
        return intersections % 2 == 1;
    }

    @Override
    public double rayCast(Ray2D ray) {
        double result = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.edges.length; ++i) {
            if (!ray.getDirection().isParallel(this.edges[i])) {
                double len2;
                double divisor = ray.getDirection().getX() * this.edges[i].getX() - ray.getDirection().getX() * this.edges[i].getY();
                double len1 = (this.vertexes[i].getY() * this.edges[i].getX() - ray.getStart().getY() * this.edges[i].getX() - this.vertexes[i].getX() * this.edges[i].getY() + ray.getStart().getX() * this.edges[i].getY()) / divisor;
                if (!(len1 > 0.0) || !((len2 = (ray.getDirection().getY() * ray.getStart().getX() - ray.getDirection().getY() * this.vertexes[i].getX() - ray.getDirection().getX() * ray.getStart().getY() + ray.getDirection().getX() * this.vertexes[i].getY()) / divisor) >= 0.0) || !(len2 <= 1.0)) continue;
                result = result > len1 ? len1 : result;
                continue;
            }
            Vector2D startVec = ray.getStart().vec(this.vertexes[i]);
            if (ray.getDirection().isAbsoluteParallel(startVec)) {
                return startVec.length();
            }
            Point2D endVertex = this.isClosed && i == this.edges.length - 1 ? this.vertexes[0] : this.vertexes[i + 1];
            Vector2D endVec = ray.getStart().vec(endVertex);
            if (!ray.getDirection().isAbsoluteParallel(endVec)) continue;
            return endVec.length();
        }
        return result * ray.getDirection().length();
    }

    @Override
    public Rect2D getBounds() {
        return this.boundingRect;
    }

    @Override
    public Polyline2D transform(TransformMatrix2D matrix) {
        Point2D[] vertexesNew = new Point2D[this.vertexes.length];
        for (int i = 0; i < this.vertexes.length; ++i) {
            vertexesNew[i] = matrix.multiply(this.vertexes[i]);
        }
        return new Polyline2D(vertexesNew, this.isClosed || Util.compareDoubles(vertexesNew[0].getX(), vertexesNew[this.vertexes.length - 1].getX()) && Util.compareDoubles(vertexesNew[0].getY(), vertexesNew[this.vertexes.length - 1].getY()));
    }
}

