/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom.shapes;

import aima.core.util.Util;
import aima.core.util.math.geom.shapes.Vector2D;

public class Point2D
implements Cloneable {
    private double x;
    private double y;

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double distance(Point2D pt) {
        double x_distance = (pt.getX() - this.x) * (pt.getX() - this.x);
        double y_distance = (pt.getY() - this.y) * (pt.getY() - this.y);
        return Math.sqrt(x_distance + y_distance);
    }

    public Point2D add(Vector2D op2) {
        return new Point2D(this.x + op2.getX(), this.y + op2.getY());
    }

    public Point2D sub(Vector2D op2) {
        return new Point2D(this.x - op2.getX(), this.y - op2.getY());
    }

    public Vector2D vec(Point2D target) {
        return new Vector2D(target.getX() - this.x, target.getY() - this.y);
    }

    public boolean equals(Point2D op2) {
        if (op2 == null) {
            return false;
        }
        return Util.compareDoubles(this.x, op2.x) && Util.compareDoubles(this.y, op2.y);
    }

    public boolean equals(Object o) {
        if (o instanceof Point2D) {
            return this.equals((Point2D)o);
        }
        return false;
    }

    public Point2D clone() {
        return new Point2D(this.x, this.y);
    }
}

