/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom.shapes;

import aima.core.util.Util;
import aima.core.util.math.geom.shapes.IGeometric2D;
import aima.core.util.math.geom.shapes.Point2D;
import aima.core.util.math.geom.shapes.Ray2D;
import aima.core.util.math.geom.shapes.Rect2D;
import aima.core.util.math.geom.shapes.TransformMatrix2D;
import aima.core.util.math.geom.shapes.Vector2D;

public final class Line2D
implements IGeometric2D {
    private final Point2D start;
    private final Vector2D line;
    private final Point2D end;
    private final boolean zeroX;
    private final boolean zeroY;

    public Line2D(Point2D start, Vector2D line) {
        this.start = start;
        this.line = line;
        this.end = start.add(line);
        this.zeroX = Util.compareDoubles(line.getX(), 0.0);
        this.zeroY = Util.compareDoubles(line.getY(), 0.0);
    }

    public Line2D(Point2D start, Point2D end) {
        this.start = start;
        this.line = start.vec(end);
        this.end = end;
        this.zeroX = Util.compareDoubles(this.line.getX(), 0.0);
        this.zeroY = Util.compareDoubles(this.line.getY(), 0.0);
    }

    public Line2D(double startX, double startY, double endX, double endY) {
        this.start = new Point2D(startX, startY);
        this.line = new Vector2D(endX - startX, endY - startY);
        this.end = new Point2D(endX, endY);
        this.zeroX = Util.compareDoubles(this.line.getX(), 0.0);
        this.zeroY = Util.compareDoubles(this.line.getY(), 0.0);
    }

    public Point2D getStart() {
        return this.start;
    }

    public Vector2D getDirection() {
        return this.line;
    }

    public Point2D getEnd() {
        return this.end;
    }

    @Override
    public Point2D randomPoint() {
        if (this.zeroX && this.zeroY) {
            return this.start.clone();
        }
        if (this.zeroX) {
            return new Point2D(this.start.getX(), Util.generateRandomDoubleBetween(this.start.getY(), this.end.getY()));
        }
        if (this.zeroY) {
            return new Point2D(Util.generateRandomDoubleBetween(this.start.getX(), this.end.getX()), this.start.getY());
        }
        double x = Util.generateRandomDoubleBetween(this.start.getX(), this.end.getX());
        double y = (x - this.start.getX()) / this.line.getX() * this.line.getY() + this.start.getY();
        return new Point2D(x, y);
    }

    @Override
    public boolean isInside(Point2D point) {
        return false;
    }

    @Override
    public boolean isInsideBorder(Point2D point) {
        if (this.zeroX && this.zeroY) {
            return this.start.equals(point);
        }
        if (this.zeroX) {
            double len = (point.getY() - this.start.getY()) / this.line.getY();
            return len <= 1.0 && len >= 0.0 && Util.compareDoubles(this.start.getX(), point.getX());
        }
        if (this.zeroY) {
            double len = (point.getX() - this.start.getX()) / this.line.getX();
            return len <= 1.0 && len >= 0.0 && Util.compareDoubles(this.start.getY(), point.getY());
        }
        double len1 = (point.getX() - this.start.getX()) / this.line.getX();
        double len2 = (point.getY() - this.start.getY()) / this.line.getY();
        return len1 <= 1.0 && len1 >= 0.0 && Util.compareDoubles(len1, len2);
    }

    @Override
    public double rayCast(Ray2D ray) {
        if (!ray.getDirection().isParallel(this.line)) {
            double len2;
            double divisor = ray.getDirection().getY() * this.line.getX() - ray.getDirection().getX() * this.line.getY();
            if (Util.compareDoubles(divisor, 0.0)) {
                return Double.POSITIVE_INFINITY;
            }
            double len1 = (this.start.getY() * this.line.getX() - ray.getStart().getY() * this.line.getX() - this.start.getX() * this.line.getY() + ray.getStart().getX() * this.line.getY()) / divisor;
            if (len1 > 0.0 && (len2 = (ray.getDirection().getY() * ray.getStart().getX() - ray.getDirection().getY() * this.start.getX() - ray.getDirection().getX() * ray.getStart().getY() + ray.getDirection().getX() * this.start.getY()) / divisor) >= 0.0 && len2 <= 1.0) {
                return len1 * ray.getDirection().length();
            }
        } else {
            Vector2D startVec = ray.getStart().vec(this.start);
            if (ray.getDirection().isAbsoluteParallel(startVec)) {
                return startVec.length();
            }
            Vector2D endVec = ray.getStart().vec(this.end);
            if (ray.getDirection().isAbsoluteParallel(endVec)) {
                return endVec.length();
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Rect2D getBounds() {
        return new Rect2D(this.start.getX(), this.start.getY(), this.end.getX(), this.end.getY());
    }

    @Override
    public Line2D transform(TransformMatrix2D matrix) {
        Point2D startNew = matrix.multiply(this.start);
        Point2D endNew = matrix.multiply(this.end);
        return new Line2D(startNew, endNew);
    }
}

