/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom.shapes;

import aima.core.util.Util;
import aima.core.util.math.geom.shapes.Circle2D;
import aima.core.util.math.geom.shapes.IGeometric2D;
import aima.core.util.math.geom.shapes.Point2D;
import aima.core.util.math.geom.shapes.Ray2D;
import aima.core.util.math.geom.shapes.Rect2D;
import aima.core.util.math.geom.shapes.TransformMatrix2D;
import aima.core.util.math.geom.shapes.Vector2D;

public class Ellipse2D
implements IGeometric2D {
    private final Point2D center;
    private final Vector2D horizontal;
    private final double horizontalLength;
    private final Vector2D vertical;
    private final double verticalLength;
    private final double angle;
    private final TransformMatrix2D transform;
    private final TransformMatrix2D transformInverse;

    public Ellipse2D(Point2D center, double rx, double ry) {
        this.center = center;
        this.horizontal = new Vector2D(rx, 0.0);
        this.horizontalLength = rx;
        this.vertical = new Vector2D(0.0, ry);
        this.verticalLength = ry;
        this.angle = 0.0;
        this.transform = TransformMatrix2D.UNITY_MATRIX;
        this.transformInverse = TransformMatrix2D.UNITY_MATRIX;
    }

    public Ellipse2D(Point2D center, Vector2D horizontal, Vector2D vertical) {
        this.center = center;
        if (Util.compareDoubles(horizontal.getX(), 0.0) && Util.compareDoubles(vertical.getY(), 0.0)) {
            this.horizontal = vertical;
            this.vertical = horizontal;
        } else {
            this.horizontal = horizontal;
            this.vertical = vertical;
        }
        this.horizontalLength = this.horizontal.length();
        this.verticalLength = this.vertical.length();
        if (Util.compareDoubles(this.horizontal.getY(), 0.0) && Util.compareDoubles(this.vertical.getX(), 0.0)) {
            this.angle = 0.0;
            this.transform = TransformMatrix2D.UNITY_MATRIX;
            this.transformInverse = TransformMatrix2D.UNITY_MATRIX;
        } else {
            this.angle = Util.compareDoubles(this.horizontal.getX(), 0.0) ? Vector2D.Y_VECTOR.angleTo(this.vertical) : Vector2D.X_VECTOR.angleTo(this.horizontal);
            TransformMatrix2D result = TransformMatrix2D.translate(center.getX(), center.getY());
            result = result.multiply(TransformMatrix2D.rotate(-this.angle));
            this.transform = result.multiply(TransformMatrix2D.translate(-center.getX(), -center.getY()));
            this.transformInverse = this.transform.inverse();
        }
    }

    public Point2D getCenter() {
        return this.center;
    }

    public double getHorizontalLength() {
        return this.horizontalLength;
    }

    public double getVerticalLength() {
        return this.verticalLength;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public Point2D randomPoint() {
        double x = Util.generateRandomDoubleBetween(-this.horizontalLength, this.horizontalLength);
        double delta = Math.abs(this.verticalLength * Math.sin(Math.acos(x / this.horizontalLength)));
        double y = Util.generateRandomDoubleBetween(-delta, delta);
        return this.transformInverse.multiply(new Point2D(this.center.getX() + x, this.center.getY() + y));
    }

    @Override
    public boolean isInside(Point2D point) {
        Point2D transformedPoint = this.transform.multiply(point);
        if (this.center.getX() - this.horizontalLength < transformedPoint.getX() && this.center.getX() + this.horizontalLength > transformedPoint.getX()) {
            double delta = Math.abs(this.verticalLength * Math.sin(Math.acos((transformedPoint.getX() - this.center.getX()) / this.horizontalLength)));
            return transformedPoint.getY() < this.center.getY() + delta && transformedPoint.getY() > this.center.getY() - delta;
        }
        return false;
    }

    @Override
    public boolean isInsideBorder(Point2D point) {
        Point2D transformedPoint = this.transform.multiply(point);
        if ((this.center.getX() - this.horizontalLength < transformedPoint.getX() || Util.compareDoubles(transformedPoint.getX(), this.center.getX() - this.horizontalLength)) && (this.center.getX() + this.horizontalLength > transformedPoint.getX() || Util.compareDoubles(transformedPoint.getX(), this.center.getX() + this.horizontalLength))) {
            double delta = Math.abs(this.verticalLength * Math.sin(Math.acos((transformedPoint.getX() - this.center.getX()) / this.horizontalLength)));
            return (transformedPoint.getY() < this.center.getY() + delta || Util.compareDoubles(transformedPoint.getY(), this.center.getY() + delta)) && (transformedPoint.getY() >= this.center.getY() - delta || Util.compareDoubles(transformedPoint.getY(), this.center.getY() - delta));
        }
        return false;
    }

    @Override
    public double rayCast(Ray2D ray) {
        Ray2D transformedRay = ray.transform(this.transform);
        double squaredHorizontal = this.horizontalLength * this.horizontalLength;
        double squaredVertical = this.verticalLength * this.verticalLength;
        double squaredDirectionX = transformedRay.getDirection().getX() * transformedRay.getDirection().getX();
        double divisor = squaredHorizontal * transformedRay.getDirection().getY() * transformedRay.getDirection().getY() + squaredVertical * squaredDirectionX;
        if (Util.compareDoubles(divisor, 0.0)) {
            return Double.POSITIVE_INFINITY;
        }
        double squareRoot = Math.sqrt(squaredHorizontal * squaredVertical * (squaredDirectionX * (squaredVertical - this.center.getY() * this.center.getY() + transformedRay.getStart().getY() * (2.0 * this.center.getY() - transformedRay.getStart().getY())) + transformedRay.getDirection().getY() * (transformedRay.getDirection().getY() * (squaredHorizontal - this.center.getX() * this.center.getX() + transformedRay.getStart().getX() * (2.0 * this.center.getX() - transformedRay.getStart().getX())) + 2.0 * transformedRay.getDirection().getX() * (transformedRay.getStart().getX() * (transformedRay.getStart().getY() - this.center.getY()) + this.center.getX() * (this.center.getY() - transformedRay.getStart().getY())))));
        if (Util.compareDoubles(squareRoot, Double.NaN)) {
            return Double.POSITIVE_INFINITY;
        }
        double tmpFactor1 = squaredVertical * transformedRay.getDirection().getX();
        double tmpFactor2 = squaredHorizontal * transformedRay.getDirection().getY();
        double factors = tmpFactor1 * this.center.getX() - tmpFactor1 * transformedRay.getStart().getX() + tmpFactor2 * this.center.getY() - tmpFactor2 * transformedRay.getStart().getY();
        double result = (factors - Math.abs(squareRoot)) / divisor;
        if (result >= 0.0) {
            Point2D intersection = transformedRay.getStart().add(transformedRay.getDirection().multiply(result));
            return this.transformInverse.multiply(intersection).vec(ray.getStart()).length();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Rect2D getBounds() {
        double cosAngle = Math.cos(this.angle);
        double sinAngle = Math.sin(this.angle);
        double boundX = Math.sqrt(this.horizontalLength * this.horizontalLength * cosAngle * cosAngle + this.verticalLength * this.verticalLength * sinAngle * sinAngle);
        double boundY = Math.sqrt(this.horizontalLength * this.horizontalLength * sinAngle * sinAngle + this.verticalLength * this.verticalLength * cosAngle * cosAngle);
        return new Rect2D(this.center.getX() - boundX, this.center.getY() - boundY, this.center.getX() + boundX, this.center.getY() + boundY);
    }

    @Override
    public IGeometric2D transform(TransformMatrix2D matrix) {
        double radiusVerticalNew;
        Point2D centerNew = matrix.multiply(this.center);
        Vector2D horizontalNew = centerNew.vec(matrix.multiply(this.center.add(this.horizontal)));
        Vector2D verticalNew = centerNew.vec(matrix.multiply(this.center.add(this.vertical)));
        double radiusHorizontalNew = horizontalNew.length();
        if (Util.compareDoubles(radiusHorizontalNew, radiusVerticalNew = verticalNew.length())) {
            return new Circle2D(centerNew, radiusHorizontalNew);
        }
        return new Ellipse2D(centerNew, horizontalNew, verticalNew);
    }
}

