/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom.shapes;

import aima.core.util.Util;
import aima.core.util.math.geom.shapes.Ellipse2D;
import aima.core.util.math.geom.shapes.IGeometric2D;
import aima.core.util.math.geom.shapes.Point2D;
import aima.core.util.math.geom.shapes.Ray2D;
import aima.core.util.math.geom.shapes.Rect2D;
import aima.core.util.math.geom.shapes.TransformMatrix2D;
import aima.core.util.math.geom.shapes.Vector2D;

public class Circle2D
implements IGeometric2D {
    private final Point2D center;
    private final double radius;

    public Circle2D(Point2D center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public Circle2D(double cx, double cy, double radius) {
        this.center = new Point2D(cx, cy);
        this.radius = radius;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public Point2D randomPoint() {
        double x = Util.generateRandomDoubleBetween(-this.radius, this.radius);
        double maxY = Math.sqrt(this.radius * this.radius - x * x);
        double y = Util.generateRandomDoubleBetween(-maxY, maxY);
        return new Point2D(this.center.getX() + x, this.center.getY() + y);
    }

    @Override
    public boolean isInside(Point2D point) {
        return this.center.vec(point).length() < this.radius;
    }

    @Override
    public boolean isInsideBorder(Point2D point) {
        return this.center.vec(point).length() <= this.radius;
    }

    @Override
    public double rayCast(Ray2D ray) {
        double divisor = ray.getDirection().getX() * ray.getDirection().getX() + ray.getDirection().getY() * ray.getDirection().getY();
        if (Util.compareDoubles(divisor, 0.0)) {
            return Double.POSITIVE_INFINITY;
        }
        double squareRoot = Math.sqrt(ray.getDirection().getY() * (ray.getDirection().getY() * (this.radius * this.radius + ray.getStart().getX() * (2.0 * this.center.getX() - ray.getStart().getX()) - this.center.getX() * this.center.getX()) + 2.0 * ray.getDirection().getX() * (ray.getStart().getX() * (ray.getStart().getY() - this.center.getY()) + this.center.getX() * (this.center.getY() - ray.getStart().getY()))) + ray.getDirection().getX() * ray.getDirection().getX() * (this.radius * this.radius + ray.getStart().getY() * (2.0 * this.center.getY() - ray.getStart().getY()) - this.center.getY() * this.center.getY()));
        if (Util.compareDoubles(squareRoot, Double.NaN)) {
            return Double.POSITIVE_INFINITY;
        }
        double factors = ray.getDirection().getX() * (this.center.getX() - ray.getStart().getX()) + ray.getDirection().getY() * (this.center.getY() - ray.getStart().getY());
        double result = (factors - Math.abs(squareRoot)) / divisor;
        if (result >= 0.0) {
            return ray.getDirection().length() * result;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Rect2D getBounds() {
        return new Rect2D(this.center.getX() - this.radius, this.center.getY() - this.radius, this.center.getX() + this.radius, this.center.getY() + this.radius);
    }

    @Override
    public IGeometric2D transform(TransformMatrix2D matrix) {
        double radiusYNew;
        Point2D centerNew = matrix.multiply(this.center);
        Point2D maxXNew = matrix.multiply(new Point2D(this.center.getX() + this.radius, this.center.getY()));
        Point2D maxYNew = matrix.multiply(new Point2D(this.center.getX(), this.center.getY() + this.radius));
        Vector2D vectorXNew = centerNew.vec(maxXNew);
        Vector2D vectorYNew = centerNew.vec(maxYNew);
        double radiusXNew = vectorXNew.length();
        if (Util.compareDoubles(radiusXNew, radiusYNew = vectorYNew.length())) {
            return new Circle2D(centerNew, radiusXNew);
        }
        if (Util.compareDoubles(maxXNew.getY(), centerNew.getY()) && Util.compareDoubles(maxYNew.getX(), centerNew.getX())) {
            return new Ellipse2D(centerNew, radiusXNew, radiusYNew);
        }
        return new Ellipse2D(centerNew, vectorXNew, vectorYNew);
    }
}

