/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom;

import aima.core.util.math.geom.IGroupParser;
import aima.core.util.math.geom.shapes.Circle2D;
import aima.core.util.math.geom.shapes.Ellipse2D;
import aima.core.util.math.geom.shapes.IGeometric2D;
import aima.core.util.math.geom.shapes.Line2D;
import aima.core.util.math.geom.shapes.Point2D;
import aima.core.util.math.geom.shapes.Polyline2D;
import aima.core.util.math.geom.shapes.Rect2D;
import aima.core.util.math.geom.shapes.TransformMatrix2D;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SVGGroupParser
implements IGroupParser {
    private static final String GROUP_ELEMENT = "g";
    private static final String CIRCLE_ELEMENT = "circle";
    private static final String ELLIPSE_ELEMENT = "ellipse";
    private static final String LINE_ELEMENT = "line";
    private static final String POLYLINE_ELEMENT = "polyline";
    private static final String POLYGON_ELEMENT = "polygon";
    private static final String RECT_ELEMENT = "rect";
    private static final String ID_ATTRIBUTE = "id";
    private static final String TRANSFORM_ATTRIBUTE = "transform";
    private static final String X_ATTRIBUTE = "x";
    private static final String Y_ATTRIBUTE = "y";
    private static final String CX_ATTRIBUTE = "cx";
    private static final String CY_ATTRIBUTE = "cy";
    private static final String X1_ATTRIBUTE = "x1";
    private static final String Y1_ATTRIBUTE = "y1";
    private static final String X2_ATTRIBUTE = "x2";
    private static final String Y2_ATTRIBUTE = "y2";
    private static final String R_ATTRIBUTE = "r";
    private static final String RX_ATTRIBUTE = "rx";
    private static final String RY_ATTRIBUTE = "ry";
    private static final String WIDTH_ATTRIBUTE = "width";
    private static final String HEIGHT_ATTRIBUTE = "height";
    private static final String POINTS_ATTRIBUTE = "points";
    private static final String TRANSLATE_TRANSFORM = "translate";
    private static final String SCALE_TRANSFORM = "scale";
    private static final String ROTATE_TRANSFORM = "rotate";
    private static final String POINTS_REGEX = "[,\\s]+";
    private static final String TRANSFORM_REGEX1 = "[a-zA-Z]*\\([0-9.,Ee\\+\\-\\s]*\\)";
    private static final String TRANSFORM_REGEX2 = "([a-zA-Z]+)|([0-9\\.Ee\\+\\-]*[eEmMxXpPiInNcCtT%]*[^\\,\\(\\)\\s]+)";
    private static final String NUMBER_REGEX = "([\\+\\-]?[0-9]+\\.?[0-9]*[Ee]?[\\+\\-]?[0-9]*\\.?[0-9]*)|em|ex|px|in|cm|mm|pt|pc|\\%";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([\\+\\-]?[0-9]+\\.?[0-9]*[Ee]?[\\+\\-]?[0-9]*\\.?[0-9]*)|em|ex|px|in|cm|mm|pt|pc|\\%");
    private static final Pattern TRANSFORM_PATTERN1 = Pattern.compile("[a-zA-Z]*\\([0-9.,Ee\\+\\-\\s]*\\)");
    private static final Pattern TRANSFORM_PATTERN2 = Pattern.compile("([a-zA-Z]+)|([0-9\\.Ee\\+\\-]*[eEmMxXpPiInNcCtT%]*[^\\,\\(\\)\\s]+)");
    private static final XMLInputFactory FACTORY = XMLInputFactory.newInstance();
    private XMLStreamReader reader;
    private ArrayList<IGeometric2D> shapes;
    private Stack<TransformMatrix2D> transformations = new Stack();
    private TransformMatrix2D currentMatrix;

    @Override
    public ArrayList<IGeometric2D> parse(InputStream input, String groupID) throws XMLStreamException {
        if (input == null || groupID == null) {
            throw new NullPointerException();
        }
        this.reader = FACTORY.createXMLStreamReader(input);
        this.shapes = new ArrayList();
        this.transformations.clear();
        this.currentMatrix = TransformMatrix2D.UNITY_MATRIX;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            if (event == 1) {
                String element;
                this.applyTransform();
                if (!this.reader.getLocalName().equalsIgnoreCase(GROUP_ELEMENT) || (element = this.reader.getAttributeValue(null, ID_ATTRIBUTE)) == null || !element.equalsIgnoreCase(groupID)) continue;
                this.parseGroup();
                break;
            }
            if (event != 2) continue;
            this.applyTransformEnd();
        }
        return this.shapes;
    }

    private void parseGroup() throws XMLStreamException {
        int groupCounter = 1;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            if (event == 1) {
                this.applyTransform();
                String elementName = this.reader.getLocalName();
                if (elementName.equalsIgnoreCase(CIRCLE_ELEMENT)) {
                    this.parseCircle();
                    continue;
                }
                if (elementName.equalsIgnoreCase(ELLIPSE_ELEMENT)) {
                    this.parseEllipse();
                    continue;
                }
                if (elementName.equalsIgnoreCase(LINE_ELEMENT)) {
                    this.parseLine();
                    continue;
                }
                if (elementName.equalsIgnoreCase(POLYLINE_ELEMENT)) {
                    this.parsePolyline();
                    continue;
                }
                if (elementName.equalsIgnoreCase(POLYGON_ELEMENT)) {
                    this.parsePolygon();
                    continue;
                }
                if (!elementName.equalsIgnoreCase(RECT_ELEMENT)) continue;
                this.parseRect();
                continue;
            }
            if (event != 2) continue;
            this.applyTransformEnd();
            if (!this.reader.getLocalName().equalsIgnoreCase(GROUP_ELEMENT) || --groupCounter != 0) continue;
            break;
        }
    }

    private void applyTransform() {
        String value = this.reader.getAttributeValue(null, TRANSFORM_ATTRIBUTE);
        this.transformations.push(this.currentMatrix);
        this.currentMatrix = this.currentMatrix.multiply(this.parseTransform(value));
    }

    private void applyTransformEnd() {
        this.currentMatrix = this.transformations.pop();
    }

    private TransformMatrix2D parseTransform(String string) {
        TransformMatrix2D result = TransformMatrix2D.UNITY_MATRIX;
        if (string != null) {
            Matcher matcher1 = TRANSFORM_PATTERN1.matcher(string);
            int transformCount1 = 0;
            while (matcher1.lookingAt()) {
                ++transformCount1;
            }
            for (int j = 1; j <= transformCount1; ++j) {
                Matcher matcher2 = TRANSFORM_PATTERN2.matcher(matcher1.group(j));
                int transformCount2 = 0;
                while (matcher1.lookingAt()) {
                    ++transformCount2;
                }
                int i = 1;
                while (i < transformCount2) {
                    if (matcher2.group(i).equalsIgnoreCase(TRANSLATE_TRANSFORM)) {
                        double tx = this.parseNumber(matcher2.group(++i));
                        double ty = 0.0;
                        ++i;
                        try {
                            ty = this.parseNumber(matcher2.group(i));
                            ++i;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        result = result.multiply(TransformMatrix2D.translate(tx, ty));
                        continue;
                    }
                    if (matcher2.group(i).equalsIgnoreCase(SCALE_TRANSFORM)) {
                        double sx;
                        double sy = sx = this.parseNumber(matcher2.group(++i));
                        ++i;
                        try {
                            sy = this.parseNumber(matcher2.group(i));
                            ++i;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        result = result.multiply(TransformMatrix2D.scale(sx, sy));
                        continue;
                    }
                    if (matcher2.group(i).equalsIgnoreCase(ROTATE_TRANSFORM)) {
                        double angle = Math.toRadians(this.parseNumber(matcher2.group(++i)));
                        double cx = 0.0;
                        double cy = 0.0;
                        ++i;
                        try {
                            cx = this.parseNumber(matcher2.group(i));
                            cy = this.parseNumber(matcher2.group(++i));
                            ++i;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (cx != 0.0 && cy != 0.0) {
                            result = result.multiply(TransformMatrix2D.translate(cx, cy));
                        }
                        result = result.multiply(TransformMatrix2D.rotate(angle));
                        if (cx == 0.0 || cy == 0.0) continue;
                        result = result.multiply(TransformMatrix2D.translate(-cx, -cy));
                        continue;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private void parseRect() {
        String value = this.reader.getAttributeValue(null, X_ATTRIBUTE);
        double x = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, Y_ATTRIBUTE);
        double y = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, WIDTH_ATTRIBUTE);
        double width = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, HEIGHT_ATTRIBUTE);
        double height = this.parseNumber(value);
        if (width != 0.0 && height != 0.0) {
            IGeometric2D rect = new Rect2D(x, y, x + width, y + height).transform(this.currentMatrix);
            this.shapes.add(rect);
        }
    }

    private void parseCircle() {
        String value = this.reader.getAttributeValue(null, CX_ATTRIBUTE);
        double cx = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, CY_ATTRIBUTE);
        double cy = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, R_ATTRIBUTE);
        double r = this.parseNumber(value);
        if (r != 0.0) {
            IGeometric2D circle = new Circle2D(new Point2D(cx, cy), r).transform(this.currentMatrix);
            this.shapes.add(circle);
        }
    }

    private void parseEllipse() {
        String value = this.reader.getAttributeValue(null, CX_ATTRIBUTE);
        double cx = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, CY_ATTRIBUTE);
        double cy = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, RX_ATTRIBUTE);
        double rx = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, RY_ATTRIBUTE);
        double ry = this.parseNumber(value);
        if (rx != 0.0 && ry != 0.0) {
            IGeometric2D elipse = new Ellipse2D(new Point2D(cx, cy), rx, ry).transform(this.currentMatrix);
            this.shapes.add(elipse);
        }
    }

    private void parseLine() {
        String value = this.reader.getAttributeValue(null, X1_ATTRIBUTE);
        double x1 = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, Y1_ATTRIBUTE);
        double y1 = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, X2_ATTRIBUTE);
        double x2 = this.parseNumber(value);
        value = this.reader.getAttributeValue(null, Y2_ATTRIBUTE);
        double y2 = this.parseNumber(value);
        Line2D line = new Line2D(x1, y1, x2, y2).transform(this.currentMatrix);
        this.shapes.add(line);
    }

    private void parsePolyline() {
        String[] coords;
        String value = this.reader.getAttributeValue(null, POINTS_ATTRIBUTE);
        if (value != null && (coords = value.split(POINTS_REGEX)).length >= 2 && coords.length % 2 == 0) {
            Point2D[] vertexes = new Point2D[coords.length / 2];
            for (int i = 0; i < coords.length; i += 2) {
                vertexes[i / 2 - 1] = new Point2D(this.parseNumber(coords[i]), this.parseNumber(coords[i + 1]));
            }
            Polyline2D polyline = new Polyline2D(vertexes, false).transform(this.currentMatrix);
            this.shapes.add(polyline);
        }
    }

    private void parsePolygon() {
        String[] coords;
        String value = this.reader.getAttributeValue(null, POINTS_ATTRIBUTE);
        if (value != null && (coords = value.split(POINTS_REGEX)).length >= 2 && coords.length % 2 == 0) {
            Point2D[] vertexes = new Point2D[coords.length / 2];
            for (int i = 1; i < coords.length; i += 2) {
                vertexes[(i - 1) / 2] = new Point2D(this.parseNumber(coords[i - 1]), this.parseNumber(coords[i]));
            }
            Polyline2D polygon = new Polyline2D(vertexes, true).transform(this.currentMatrix);
            this.shapes.add(polygon);
        }
    }

    private double parseNumber(String string) {
        if (string == null) {
            return 0.0;
        }
        Matcher matcher = NUMBER_PATTERN.matcher(string);
        if (!matcher.lookingAt()) {
            return 0.0;
        }
        String group = matcher.group(1);
        if (group == null) {
            return 0.0;
        }
        return Double.valueOf(group);
    }
}

