/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math.geom;

import aima.core.util.Util;
import aima.core.util.math.geom.IGroupParser;
import aima.core.util.math.geom.shapes.IGeometric2D;
import aima.core.util.math.geom.shapes.Point2D;
import aima.core.util.math.geom.shapes.Ray2D;
import aima.core.util.math.geom.shapes.Rect2D;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class CartesianPlot2D {
    private double rayRange;
    private IGroupParser parser;
    private ArrayList<IGeometric2D> shapes;
    private ArrayList<Rect2D> boundaries;

    public CartesianPlot2D(IGroupParser parser) {
        this.parser = parser;
    }

    public void setRayRange(double rayRange) {
        this.rayRange = rayRange;
    }

    public void setShapes(ArrayList<IGeometric2D> shapes) {
        this.shapes = shapes;
        this.boundaries = new ArrayList(shapes.size());
        for (IGeometric2D shape : shapes) {
            this.boundaries.add(shape.getBounds());
        }
    }

    public void loadMap(InputStream input, String groupID) throws Exception {
        this.shapes = this.parser.parse(input, groupID);
        this.boundaries = new ArrayList(this.shapes.size());
        for (IGeometric2D shape : this.shapes) {
            this.boundaries.add(shape.getBounds());
        }
    }

    public Iterator<IGeometric2D> getShapes() {
        return this.shapes.iterator();
    }

    public Iterator<Rect2D> getBoundaries() {
        return this.boundaries.iterator();
    }

    public boolean isEmpty() {
        return this.shapes == null ? true : this.shapes.isEmpty();
    }

    public Point2D randomPoint() {
        IGeometric2D shape = Util.selectRandomlyFromList(this.shapes);
        return shape.randomPoint();
    }

    public double rayCast(Ray2D ray) {
        double result = Double.POSITIVE_INFINITY;
        Rect2D rayBounding = new Rect2D(ray.getStart().getX() - this.rayRange, ray.getStart().getY() - this.rayRange, ray.getStart().getX() + this.rayRange, ray.getStart().getY() + this.rayRange);
        for (int i = 0; i < this.shapes.size(); ++i) {
            Rect2D bounding = this.boundaries.get(i);
            if (!rayBounding.isInsideBorder(bounding.getLowerLeft()) && !rayBounding.isInsideBorder(bounding.getUpperLeft()) && !rayBounding.isInsideBorder(bounding.getLowerRight()) && !rayBounding.isInsideBorder(bounding.getUpperRight())) continue;
            double tmp = this.shapes.get(i).rayCast(ray);
            result = tmp < result ? tmp : result;
        }
        return result;
    }

    public boolean isPointInsideBorderShape(Point2D point) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (!this.boundaries.get(i).isInsideBorder(point) || !this.shapes.get(i).isInsideBorder(point)) continue;
            return true;
        }
        return false;
    }

    public boolean isPointInsideShape(Point2D point) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (!this.boundaries.get(i).isInside(point) || !this.shapes.get(i).isInside(point)) continue;
            return true;
        }
        return false;
    }
}

