/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math;

import aima.core.util.math.Matrix;
import java.util.List;

public class Vector
extends Matrix {
    private static final long serialVersionUID = 1L;

    public Vector(int size) {
        super(size, 1);
    }

    public Vector(List<Double> lst) {
        super(lst.size(), 1);
        for (int i = 0; i < lst.size(); ++i) {
            this.setValue(i, lst.get(i));
        }
    }

    public double getValue(int i) {
        return super.get(i, 0);
    }

    public void setValue(int index, double value) {
        super.set(index, 0, value);
    }

    public Vector copyVector() {
        Vector result = new Vector(this.getRowDimension());
        for (int i = 0; i < this.getRowDimension(); ++i) {
            result.setValue(i, this.getValue(i));
        }
        return result;
    }

    public int size() {
        return this.getRowDimension();
    }

    public Vector minus(Vector v) {
        Vector result = new Vector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setValue(i, this.getValue(i) - v.getValue(i));
        }
        return result;
    }

    public Vector plus(Vector v) {
        Vector result = new Vector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setValue(i, this.getValue(i) + v.getValue(i));
        }
        return result;
    }

    public int indexHavingMaxValue() {
        if (this.size() <= 0) {
            throw new RuntimeException("can't perform this op on empty vector");
        }
        int res = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getValue(i) > this.getValue(res))) continue;
            res = i;
        }
        return res;
    }
}

