/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math;

import java.util.List;

public class MixedRadixNumber
extends Number {
    private static final long serialVersionUID = 1L;
    private long value = 0L;
    private long maxValue = 0L;
    private int[] radices = null;
    private int[] currentNumeralValue = null;
    private boolean recalculate = true;

    public MixedRadixNumber(long value, int[] radices) {
        this.value = value;
        this.radices = new int[radices.length];
        System.arraycopy(radices, 0, this.radices, 0, radices.length);
        this.calculateMaxValue();
    }

    public MixedRadixNumber(long value, List<Integer> radices) {
        this.value = value;
        this.radices = new int[radices.size()];
        for (int i = 0; i < radices.size(); ++i) {
            this.radices[i] = radices.get(i);
        }
        this.calculateMaxValue();
    }

    public MixedRadixNumber(int[] radixValues, int[] radices) {
        this(0L, radices);
        this.setCurrentValueFor(radixValues);
    }

    public long getCurrentValueFor(int[] radixValues) {
        if (radixValues.length != this.radices.length) {
            throw new IllegalArgumentException("Radix values not same size as Radices.");
        }
        long cvalue = 0L;
        long mvalue = 1L;
        for (int i = 0; i < radixValues.length; ++i) {
            if (radixValues[i] < 0 || radixValues[i] >= this.radices[i]) {
                throw new IllegalArgumentException("Radix value " + i + " is out of range for radix at this position");
            }
            if (i > 0) {
                mvalue *= (long)this.radices[i - 1];
            }
            cvalue += mvalue * (long)radixValues[i];
        }
        return cvalue;
    }

    public void setCurrentValueFor(int[] radixValues) {
        this.value = this.getCurrentValueFor(radixValues);
        System.arraycopy(radixValues, 0, this.currentNumeralValue, 0, radixValues.length);
        this.recalculate = false;
    }

    public long getMaxAllowedValue() {
        return this.maxValue;
    }

    public boolean increment() {
        if (this.value < this.maxValue) {
            ++this.value;
            this.recalculate = true;
            return true;
        }
        return false;
    }

    public boolean decrement() {
        if (this.value > 0L) {
            --this.value;
            this.recalculate = true;
            return true;
        }
        return false;
    }

    public int getCurrentNumeralValue(int atPosition) {
        if (atPosition >= 0 && atPosition < this.radices.length) {
            if (this.recalculate) {
                long quotient = this.value;
                for (int i = 0; i < this.radices.length; ++i) {
                    if (0L != quotient) {
                        this.currentNumeralValue[i] = (int)quotient % this.radices[i];
                        quotient /= (long)this.radices[i];
                        continue;
                    }
                    this.currentNumeralValue[i] = 0;
                }
                this.recalculate = false;
            }
            return this.currentNumeralValue[atPosition];
        }
        throw new IllegalArgumentException("Argument atPosition must be >=0 and < " + this.radices.length);
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.radices.length; ++i) {
            sb.append("[");
            sb.append(this.getCurrentNumeralValue(i));
            sb.append("]");
        }
        return sb.toString();
    }

    private void calculateMaxValue() {
        int i;
        if (0 == this.radices.length) {
            throw new IllegalArgumentException("At least 1 radix must be defined.");
        }
        for (i = 0; i < this.radices.length; ++i) {
            if (this.radices[i] >= 2) continue;
            throw new IllegalArgumentException("Invalid radix, must be >= 2");
        }
        this.maxValue = this.radices[0];
        for (i = 1; i < this.radices.length; ++i) {
            this.maxValue *= (long)this.radices[i];
        }
        --this.maxValue;
        if (this.value > this.maxValue) {
            throw new IllegalArgumentException("The value [" + this.value + "] cannot be represented with the radices provided, max value is " + this.maxValue);
        }
        this.currentNumeralValue = new int[this.radices.length];
    }
}

