/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.math;

public class Interval<C> {
    private Comparable<C> lower = null;
    private boolean lowerInclusive = true;
    private Comparable<C> upper = null;
    private boolean upperInclusive = true;

    public Interval() {
    }

    public Interval(Comparable<C> lower, Comparable<C> upper) {
        this.setLower(lower);
        this.setUpper(upper);
    }

    public Interval(Comparable<C> lower, boolean lowerInclusive, Comparable<C> upper, boolean upperInclusive) {
        this.setLower(lower);
        this.setLowerInclusive(lowerInclusive);
        this.setUpper(upper);
        this.setUpperInclusive(upperInclusive);
    }

    public boolean isInInterval(C o) {
        if (null == this.lower || null == this.upper) {
            return false;
        }
        boolean in = true;
        if (this.isLowerInclusive()) {
            in = this.lower.compareTo(o) <= 0;
        } else {
            boolean bl = in = this.lower.compareTo(o) < 0;
        }
        if (in) {
            in = this.isUpperInclusive() ? this.upper.compareTo(o) >= 0 : this.upper.compareTo(o) > 0;
        }
        return in;
    }

    public boolean isLowerInclusive() {
        return this.lowerInclusive;
    }

    public boolean isLowerExclusive() {
        return !this.lowerInclusive;
    }

    public void setLowerInclusive(boolean inclusive) {
        this.lowerInclusive = inclusive;
    }

    public void setLowerExclusive(boolean exclusive) {
        this.lowerInclusive = !exclusive;
    }

    public Comparable<C> getLower() {
        return this.lower;
    }

    public void setLower(Comparable<C> lower) {
        this.lower = lower;
    }

    public boolean isUpperInclusive() {
        return this.upperInclusive;
    }

    public boolean isUpperExclusive() {
        return !this.upperInclusive;
    }

    public void setUpperInclusive(boolean inclusive) {
        this.upperInclusive = inclusive;
    }

    public void setUpperExclusive(boolean exclusive) {
        this.upperInclusive = !exclusive;
    }

    public Comparable<C> getUpper() {
        return this.upper;
    }

    public void setUpper(Comparable<C> upper) {
        this.upper = upper;
    }

    public String toString() {
        return (this.lowerInclusive ? "[" : "(") + this.lower + ", " + this.upper + (this.upperInclusive ? "]" : ")");
    }
}

