/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.datastructure;

public class XYLocation {
    int xCoOrdinate;
    int yCoOrdinate;

    public XYLocation(int x, int y) {
        this.xCoOrdinate = x;
        this.yCoOrdinate = y;
    }

    public int getXCoOrdinate() {
        return this.xCoOrdinate;
    }

    public int getYCoOrdinate() {
        return this.yCoOrdinate;
    }

    public XYLocation west() {
        return new XYLocation(this.xCoOrdinate - 1, this.yCoOrdinate);
    }

    public XYLocation east() {
        return new XYLocation(this.xCoOrdinate + 1, this.yCoOrdinate);
    }

    public XYLocation north() {
        return new XYLocation(this.xCoOrdinate, this.yCoOrdinate - 1);
    }

    public XYLocation south() {
        return new XYLocation(this.xCoOrdinate, this.yCoOrdinate + 1);
    }

    public XYLocation left() {
        return this.west();
    }

    public XYLocation right() {
        return this.east();
    }

    public XYLocation up() {
        return this.north();
    }

    public XYLocation down() {
        return this.south();
    }

    public XYLocation locationAt(Direction direction) {
        if (direction.equals((Object)Direction.North)) {
            return this.north();
        }
        if (direction.equals((Object)Direction.South)) {
            return this.south();
        }
        if (direction.equals((Object)Direction.East)) {
            return this.east();
        }
        if (direction.equals((Object)Direction.West)) {
            return this.west();
        }
        throw new RuntimeException("Unknown direction " + (Object)((Object)direction));
    }

    public boolean equals(Object o) {
        if (null == o || !(o instanceof XYLocation)) {
            return super.equals(o);
        }
        XYLocation anotherLoc = (XYLocation)o;
        return anotherLoc.getXCoOrdinate() == this.xCoOrdinate && anotherLoc.getYCoOrdinate() == this.yCoOrdinate;
    }

    public String toString() {
        return " ( " + this.xCoOrdinate + " , " + this.yCoOrdinate + " ) ";
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.xCoOrdinate;
        result = 43 * result + this.yCoOrdinate;
        return result;
    }

    public static enum Direction {
        North,
        South,
        East,
        West;

    }
}

