/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util.datastructure;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class LabeledGraph<VertexLabelType, EdgeLabelType> {
    private final Hashtable<VertexLabelType, Hashtable<VertexLabelType, EdgeLabelType>> globalEdgeLookup = new Hashtable();
    private final List<VertexLabelType> vertexLabels = new ArrayList<VertexLabelType>();

    public void addVertex(VertexLabelType v) {
        this.checkForNewVertex(v);
    }

    public void set(VertexLabelType from, VertexLabelType to, EdgeLabelType el) {
        Hashtable<VertexLabelType, EdgeLabelType> localEdgeLookup = this.checkForNewVertex(from);
        localEdgeLookup.put(to, el);
        this.checkForNewVertex(to);
    }

    private Hashtable<VertexLabelType, EdgeLabelType> checkForNewVertex(VertexLabelType v) {
        Hashtable<Object, Object> result = this.globalEdgeLookup.get(v);
        if (result == null) {
            result = new Hashtable();
            this.globalEdgeLookup.put(v, result);
            this.vertexLabels.add(v);
        }
        return result;
    }

    public void remove(VertexLabelType from, VertexLabelType to) {
        Hashtable<VertexLabelType, EdgeLabelType> localEdgeLookup = this.globalEdgeLookup.get(from);
        if (localEdgeLookup != null) {
            localEdgeLookup.remove(to);
        }
    }

    public EdgeLabelType get(VertexLabelType from, VertexLabelType to) {
        Hashtable<VertexLabelType, EdgeLabelType> localEdgeLookup = this.globalEdgeLookup.get(from);
        return localEdgeLookup == null ? null : (EdgeLabelType)localEdgeLookup.get(to);
    }

    public List<VertexLabelType> getSuccessors(VertexLabelType v) {
        ArrayList<VertexLabelType> result = new ArrayList<VertexLabelType>();
        Hashtable<VertexLabelType, EdgeLabelType> localEdgeLookup = this.globalEdgeLookup.get(v);
        if (localEdgeLookup != null) {
            result.addAll(localEdgeLookup.keySet());
        }
        return result;
    }

    public List<VertexLabelType> getVertexLabels() {
        return this.vertexLabels;
    }

    public boolean isVertexLabel(VertexLabelType v) {
        return this.globalEdgeLookup.get(v) != null;
    }

    public void clear() {
        this.vertexLabels.clear();
        this.globalEdgeLookup.clear();
    }
}

