/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Util {
    public static final String NO = "No";
    public static final String YES = "Yes";
    private static Random _r = new Random();
    private static final double EPSILON = 1.0E-12;

    public static <T> T first(List<T> l) {
        return l.get(0);
    }

    public static <T> List<T> rest(List<T> l) {
        return l.subList(1, l.size());
    }

    public static <K, V> Map<K, V> create(Collection<K> keys, V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (K k : keys) {
            map.put(k, value);
        }
        return map;
    }

    @SafeVarargs
    public static <V> Set<V> createSet(V ... values) {
        LinkedHashSet<V> set = new LinkedHashSet<V>();
        for (V v : values) {
            set.add(v);
        }
        return set;
    }

    public static <T> T selectRandomlyFromList(List<T> l) {
        return l.get(_r.nextInt(l.size()));
    }

    public static boolean randomBoolean() {
        int trueOrFalse = _r.nextInt(2);
        return trueOrFalse != 0;
    }

    public static double[] normalize(double[] probDist) {
        int len = probDist.length;
        double total = 0.0;
        for (double d : probDist) {
            total += d;
        }
        double[] normalized = new double[len];
        if (total != 0.0) {
            for (int i = 0; i < len; ++i) {
                normalized[i] = probDist[i] / total;
            }
        }
        return normalized;
    }

    public static List<Double> normalize(List<Double> values) {
        double[] valuesAsArray = new double[values.size()];
        for (int i = 0; i < valuesAsArray.length; ++i) {
            valuesAsArray[i] = values.get(i);
        }
        double[] normalized = Util.normalize(valuesAsArray);
        ArrayList<Double> results = new ArrayList<Double>();
        for (int i = 0; i < normalized.length; ++i) {
            results.add(normalized[i]);
        }
        return results;
    }

    public static int min(int i, int j) {
        return i > j ? j : i;
    }

    public static int max(int i, int j) {
        return i < j ? j : i;
    }

    public static int max(int i, int j, int k) {
        return Util.max(Util.max(i, j), k);
    }

    public static int min(int i, int j, int k) {
        return Util.min(Util.min(i, j), k);
    }

    public static <T> T mode(List<T> l) {
        Hashtable<T, Integer> hash = new Hashtable<T, Integer>();
        for (T obj : l) {
            if (hash.containsKey(obj)) {
                hash.put(obj, (Integer)hash.get(obj) + 1);
                continue;
            }
            hash.put(obj, 1);
        }
        Object maxkey = hash.keySet().iterator().next();
        for (Object key : hash.keySet()) {
            if ((Integer)hash.get(key) <= (Integer)hash.get(maxkey)) continue;
            maxkey = key;
        }
        return (T)maxkey;
    }

    public static String[] yesno() {
        return new String[]{YES, NO};
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static double information(double[] probabilities) {
        double total = 0.0;
        for (double d : probabilities) {
            total += -1.0 * Util.log2(d) * d;
        }
        return total;
    }

    public static <T> List<T> removeFrom(List<T> list, T member) {
        ArrayList<T> newList = new ArrayList<T>(list);
        newList.remove(member);
        return newList;
    }

    public static <T extends Number> double sumOfSquares(List<T> list) {
        double accum = 0.0;
        for (Number item : list) {
            accum += item.doubleValue() * item.doubleValue();
        }
        return accum;
    }

    public static String ntimes(String s, int n) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            buf.append(s);
        }
        return buf.toString();
    }

    public static void checkForNanOrInfinity(double d) {
        if (Double.isNaN(d)) {
            throw new RuntimeException("Not a Number");
        }
        if (Double.isInfinite(d)) {
            throw new RuntimeException("Infinite Number");
        }
    }

    public static int randomNumberBetween(int i, int j) {
        return _r.nextInt(j - i + 1) + i;
    }

    public static double calculateMean(List<Double> lst) {
        Double sum = 0.0;
        for (Double d : lst) {
            sum = sum + d;
        }
        return sum / (double)lst.size();
    }

    public static double calculateStDev(List<Double> values, double mean) {
        int listSize = values.size();
        Double sumOfDiffSquared = 0.0;
        for (Double value : values) {
            double diffFromMean = value - mean;
            sumOfDiffSquared = sumOfDiffSquared + diffFromMean * diffFromMean / (double)(listSize - 1);
        }
        double variance = sumOfDiffSquared;
        return Math.sqrt(variance);
    }

    public static List<Double> normalizeFromMeanAndStdev(List<Double> values, double mean, double stdev) {
        ArrayList<Double> normalized = new ArrayList<Double>();
        for (Double d : values) {
            normalized.add((d - mean) / stdev);
        }
        return normalized;
    }

    public static double generateRandomDoubleBetween(double lowerLimit, double upperLimit) {
        return lowerLimit + (upperLimit - lowerLimit) * _r.nextDouble();
    }

    public static float generateRandomFloatBetween(float lowerLimit, float upperLimit) {
        return lowerLimit + (upperLimit - lowerLimit) * _r.nextFloat();
    }

    public static boolean compareDoubles(double a, double b) {
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return true;
        }
        if (!Double.isInfinite(a) && !Double.isInfinite(b)) {
            return Math.abs(a - b) <= 1.0E-12;
        }
        return a == b;
    }

    public static boolean compareFloats(float a, float b) {
        if (Float.isNaN(a) && Float.isNaN(b)) {
            return true;
        }
        if (!Float.isInfinite(a) && !Float.isInfinite(b)) {
            return (double)Math.abs(a - b) <= 1.0E-12;
        }
        return a == b;
    }
}

