/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FrequencyCounter<T> {
    private Map<T, Integer> counter = new HashMap<T, Integer>();
    private int total = 0;

    public Integer getCount(T key) {
        Integer value = this.counter.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void incrementFor(T key) {
        Integer value = this.counter.get(key);
        if (value == null) {
            this.counter.put(key, 1);
        } else {
            this.counter.put(key, value + 1);
        }
        ++this.total;
    }

    public double probabilityOf(T key) {
        Integer value = this.getCount(key);
        if (0 == this.total || 0 == value) {
            return 0.0;
        }
        return value.doubleValue() / (double)this.total;
    }

    public Set<T> getStates() {
        return this.counter.keySet();
    }

    public void clear() {
        this.counter.clear();
        this.total = 0;
    }

    public String toString() {
        return this.counter.toString();
    }
}

