/*
 * Decompiled with CFR 0.152.
 */
package aima.core.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DisjointSets<E> {
    private Map<E, Set<E>> elementToSet = new LinkedHashMap<E, Set<E>>();
    private Set<Set<E>> disjointSets = new LinkedHashSet<Set<E>>();

    public DisjointSets() {
    }

    public DisjointSets(Collection<E> initialElements) {
        for (E element : initialElements) {
            this.makeSet(element);
        }
    }

    public DisjointSets(E ... elements) {
        for (E element : elements) {
            this.makeSet(element);
        }
    }

    public void makeSet(E element) {
        if (!this.elementToSet.containsKey(element)) {
            IdentityHashSet set = new IdentityHashSet();
            set.add(element);
            this.elementToSet.put(element, set);
            this.disjointSets.add(set);
        }
    }

    public void union(E element1, E element2) {
        block6: {
            Set<E> set1 = this.elementToSet.get(element1);
            if (set1 == null) {
                throw new IllegalArgumentException("element 1 is not associated with a disjoint set, call makeSet() first.");
            }
            Set<E> set2 = this.elementToSet.get(element2);
            if (set2 == null) {
                throw new IllegalArgumentException("element 2 is not associated with a disjoint set, call makeSet() first.");
            }
            if (set1 == set2) break block6;
            if (set1.size() < set2.size()) {
                set2.addAll(set1);
                for (E element : set1) {
                    this.disjointSets.remove(this.elementToSet.put(element, set2));
                }
            } else {
                set1.addAll(set2);
                for (E element : set2) {
                    this.disjointSets.remove(this.elementToSet.put(element, set1));
                }
            }
        }
    }

    public Set<E> find(E element) {
        return new LinkedHashSet(this.elementToSet.get(element));
    }

    public Map<E, Set<E>> getElementToDisjointSet() {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<E, Set<E>> entry : this.elementToSet.entrySet()) {
            result.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
        return result;
    }

    public Set<Set<E>> getDisjointSets() {
        LinkedHashSet result = new LinkedHashSet();
        Iterator<Set<E>> it = this.disjointSets.iterator();
        while (it.hasNext()) {
            result.add(new LinkedHashSet(it.next()));
        }
        return result;
    }

    public int numberDisjointSets() {
        return this.disjointSets.size();
    }

    public void clear() {
        this.elementToSet.clear();
        this.disjointSets.clear();
    }

    private class IdentityHashSet<H>
    extends HashSet<H> {
        private static final long serialVersionUID = 1L;

        private IdentityHashSet() {
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }
    }
}

