/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.uninformed;

import aima.core.agent.Action;
import aima.core.search.framework.Metrics;
import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.SearchForActions;
import aima.core.search.framework.SearchForStates;
import aima.core.search.framework.SearchUtils;
import aima.core.search.framework.problem.Problem;
import aima.core.search.uninformed.DepthLimitedSearch;
import aima.core.util.CancelableThread;
import java.util.List;

public class IterativeDeepeningSearch
implements SearchForActions,
SearchForStates {
    public static final String METRIC_NODES_EXPANDED = "nodesExpanded";
    public static final String METRIC_PATH_COST = "pathCost";
    private final NodeExpander nodeExpander;
    private final Metrics metrics;

    public IterativeDeepeningSearch() {
        this(new NodeExpander());
    }

    public IterativeDeepeningSearch(NodeExpander nodeExpander) {
        this.nodeExpander = nodeExpander;
        this.metrics = new Metrics();
    }

    @Override
    public List<Action> findActions(Problem p) {
        this.nodeExpander.useParentLinks(true);
        Node node = this.findNode(p);
        return node == null ? SearchUtils.failure() : SearchUtils.getSequenceOfActions(node);
    }

    @Override
    public Object findState(Problem p) {
        this.nodeExpander.useParentLinks(false);
        Node node = this.findNode(p);
        return node == null ? null : node.getState();
    }

    private Node findNode(Problem p) {
        this.clearInstrumentation();
        int i = 0;
        while (!CancelableThread.currIsCanceled()) {
            DepthLimitedSearch dls = new DepthLimitedSearch(i, this.nodeExpander);
            Node result = dls.findNode(p);
            this.updateMetrics(dls.getMetrics());
            if (result != DepthLimitedSearch.CUTOFF_NODE) {
                return result;
            }
            ++i;
        }
        return null;
    }

    @Override
    public NodeExpander getNodeExpander() {
        return this.nodeExpander;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void clearInstrumentation() {
        this.metrics.set(METRIC_NODES_EXPANDED, 0);
        this.metrics.set(METRIC_PATH_COST, 0);
    }

    private void updateMetrics(Metrics dlsMetrics) {
        this.metrics.set(METRIC_NODES_EXPANDED, this.metrics.getInt(METRIC_NODES_EXPANDED) + dlsMetrics.getInt(METRIC_NODES_EXPANDED));
        this.metrics.set(METRIC_PATH_COST, dlsMetrics.getDouble(METRIC_PATH_COST));
    }
}

