/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.uninformed;

import aima.core.agent.Action;
import aima.core.search.framework.Metrics;
import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.SearchForActions;
import aima.core.search.framework.SearchForStates;
import aima.core.search.framework.SearchUtils;
import aima.core.search.framework.problem.Problem;
import aima.core.util.CancelableThread;
import java.util.List;

public class DepthLimitedSearch
implements SearchForActions,
SearchForStates {
    public static final String METRIC_NODES_EXPANDED = "nodesExpanded";
    public static final String METRIC_PATH_COST = "pathCost";
    public static final Node CUTOFF_NODE = new Node(null);
    private final int limit;
    private final NodeExpander nodeExpander;
    private Metrics metrics = new Metrics();

    public DepthLimitedSearch(int limit) {
        this(limit, new NodeExpander());
    }

    public DepthLimitedSearch(int limit, NodeExpander nodeExpander) {
        this.limit = limit;
        this.nodeExpander = nodeExpander;
    }

    @Override
    public List<Action> findActions(Problem p) {
        this.nodeExpander.useParentLinks(true);
        Node node = this.findNode(p);
        return node == null || node == CUTOFF_NODE ? SearchUtils.failure() : SearchUtils.getSequenceOfActions(node);
    }

    @Override
    public Object findState(Problem p) {
        this.nodeExpander.useParentLinks(false);
        Node node = this.findNode(p);
        return node == null || node == CUTOFF_NODE ? null : node.getState();
    }

    public Node findNode(Problem p) {
        this.clearInstrumentation();
        return this.recursiveDLS(this.nodeExpander.createRootNode(p.getInitialState()), p, this.limit);
    }

    private Node recursiveDLS(Node node, Problem problem, int limit) {
        if (SearchUtils.isGoalState(problem, node)) {
            this.metrics.set(METRIC_PATH_COST, node.getPathCost());
            return node;
        }
        if (0 == limit || CancelableThread.currIsCanceled()) {
            return CUTOFF_NODE;
        }
        boolean cutoff_occurred = false;
        this.metrics.incrementInt(METRIC_NODES_EXPANDED);
        for (Node child : this.nodeExpander.expand(node, problem)) {
            Node result = this.recursiveDLS(child, problem, limit - 1);
            if (result == CUTOFF_NODE) {
                cutoff_occurred = true;
                continue;
            }
            if (result == null) continue;
            return result;
        }
        if (cutoff_occurred) {
            return CUTOFF_NODE;
        }
        return null;
    }

    @Override
    public NodeExpander getNodeExpander() {
        return this.nodeExpander;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void clearInstrumentation() {
        this.metrics.set(METRIC_NODES_EXPANDED, 0);
        this.metrics.set(METRIC_PATH_COST, 0);
    }
}

