/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.uninformed;

import aima.core.agent.Action;
import aima.core.search.framework.Metrics;
import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.QueueFactory;
import aima.core.search.framework.SearchForActions;
import aima.core.search.framework.SearchForStates;
import aima.core.search.framework.SearchUtils;
import aima.core.search.framework.problem.Problem;
import aima.core.search.framework.qsearch.GraphSearch;
import aima.core.search.framework.qsearch.QueueSearch;
import java.util.List;

public class BreadthFirstSearch
implements SearchForActions,
SearchForStates {
    private final QueueSearch implementation;

    public BreadthFirstSearch() {
        this(new GraphSearch());
    }

    public BreadthFirstSearch(QueueSearch impl) {
        this.implementation = impl;
        this.implementation.setEarlyGoalTest(true);
    }

    @Override
    public List<Action> findActions(Problem p) {
        this.implementation.getNodeExpander().useParentLinks(true);
        Node node = this.implementation.findNode(p, QueueFactory.createFifoQueue());
        return node == null ? SearchUtils.failure() : SearchUtils.getSequenceOfActions(node);
    }

    @Override
    public Object findState(Problem p) {
        this.implementation.getNodeExpander().useParentLinks(false);
        Node node = this.implementation.findNode(p, QueueFactory.createFifoQueue());
        return node == null ? null : node.getState();
    }

    @Override
    public NodeExpander getNodeExpander() {
        return this.implementation.getNodeExpander();
    }

    @Override
    public Metrics getMetrics() {
        return this.implementation.getMetrics();
    }
}

