/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.online;

import aima.core.agent.Action;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractAgent;
import aima.core.agent.impl.NoOpAction;
import aima.core.search.framework.PerceptToStateFunction;
import aima.core.search.online.OnlineSearchProblem;
import aima.core.util.datastructure.Pair;
import aima.core.util.datastructure.TwoKeyHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OnlineDFSAgent
extends AbstractAgent {
    private OnlineSearchProblem problem;
    private PerceptToStateFunction ptsFunction;
    private final TwoKeyHashMap<Object, Action, Object> result = new TwoKeyHashMap();
    private final Map<Object, List<Action>> untried = new HashMap<Object, List<Action>>();
    private final Map<Object, List<Object>> unbacktracked = new HashMap<Object, List<Object>>();
    private Object s = null;
    private Action a = null;

    public OnlineDFSAgent(OnlineSearchProblem problem, PerceptToStateFunction ptsFunction) {
        this.setProblem(problem);
        this.setPerceptToStateFunction(ptsFunction);
    }

    public OnlineSearchProblem getProblem() {
        return this.problem;
    }

    public void setProblem(OnlineSearchProblem problem) {
        this.problem = problem;
        this.init();
    }

    public PerceptToStateFunction getPerceptToStateFunction() {
        return this.ptsFunction;
    }

    public void setPerceptToStateFunction(PerceptToStateFunction ptsFunction) {
        this.ptsFunction = ptsFunction;
    }

    @Override
    public Action execute(Percept psDelta) {
        Object sDelta = this.ptsFunction.getState(psDelta);
        if (this.goalTest(sDelta)) {
            this.a = NoOpAction.NO_OP;
        } else {
            if (!this.untried.containsKey(sDelta)) {
                this.untried.put(sDelta, this.actions(sDelta));
            }
            if (null != this.s && !sDelta.equals(this.result.get(this.s, this.a))) {
                this.result.put(this.s, this.a, sDelta);
                if (!this.unbacktracked.containsKey(sDelta)) {
                    this.unbacktracked.put(sDelta, new ArrayList());
                }
                this.unbacktracked.get(sDelta).add(0, this.s);
            }
            if (this.untried.get(sDelta).isEmpty()) {
                if (this.unbacktracked.get(sDelta).isEmpty()) {
                    this.a = NoOpAction.NO_OP;
                } else {
                    Object popped = this.unbacktracked.get(sDelta).remove(0);
                    for (Pair sa : this.result.keySet()) {
                        if (!sa.getFirst().equals(sDelta) || !this.result.get(sa).equals(popped)) continue;
                        this.a = (Action)sa.getSecond();
                        break;
                    }
                }
            } else {
                this.a = this.untried.get(sDelta).remove(0);
            }
        }
        if (this.a.isNoOp()) {
            this.setAlive(false);
        }
        this.s = sDelta;
        return this.a;
    }

    private void init() {
        this.setAlive(true);
        this.result.clear();
        this.untried.clear();
        this.unbacktracked.clear();
        this.s = null;
        this.a = null;
    }

    private boolean goalTest(Object state) {
        return this.getProblem().isGoalState(state);
    }

    private List<Action> actions(Object state) {
        return new ArrayList<Action>(this.problem.getActionsFunction().actions(state));
    }
}

