/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.online;

import aima.core.agent.Action;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractAgent;
import aima.core.agent.impl.NoOpAction;
import aima.core.search.framework.PerceptToStateFunction;
import aima.core.search.framework.evalfunc.HeuristicFunction;
import aima.core.search.online.OnlineSearchProblem;
import aima.core.util.datastructure.TwoKeyHashMap;
import java.util.HashMap;
import java.util.Set;

public class LRTAStarAgent
extends AbstractAgent {
    private OnlineSearchProblem problem;
    private PerceptToStateFunction ptsFunction;
    private HeuristicFunction hf;
    private final TwoKeyHashMap<Object, Action, Object> result = new TwoKeyHashMap();
    private final HashMap<Object, Double> H = new HashMap();
    private Object s = null;
    private Action a = null;

    public LRTAStarAgent(OnlineSearchProblem problem, PerceptToStateFunction ptsFunction, HeuristicFunction hf) {
        this.setProblem(problem);
        this.setPerceptToStateFunction(ptsFunction);
        this.setHeuristicFunction(hf);
    }

    public OnlineSearchProblem getProblem() {
        return this.problem;
    }

    public void setProblem(OnlineSearchProblem problem) {
        this.problem = problem;
        this.init();
    }

    public PerceptToStateFunction getPerceptToStateFunction() {
        return this.ptsFunction;
    }

    public void setPerceptToStateFunction(PerceptToStateFunction ptsFunction) {
        this.ptsFunction = ptsFunction;
    }

    public HeuristicFunction getHeuristicFunction() {
        return this.hf;
    }

    public void setHeuristicFunction(HeuristicFunction hf) {
        this.hf = hf;
    }

    @Override
    public Action execute(Percept psDelta) {
        Object sDelta = this.ptsFunction.getState(psDelta);
        if (this.goalTest(sDelta)) {
            this.a = NoOpAction.NO_OP;
        } else {
            double cost;
            double min;
            if (!this.H.containsKey(sDelta)) {
                this.H.put(sDelta, this.getHeuristicFunction().h(sDelta));
            }
            if (null != this.s) {
                this.result.put(this.s, this.a, sDelta);
                min = Double.MAX_VALUE;
                for (Action b : this.actions(this.s)) {
                    cost = this.lrtaCost(this.s, b, this.result.get(this.s, b));
                    if (!(cost < min)) continue;
                    min = cost;
                }
                this.H.put(this.s, min);
            }
            min = Double.MAX_VALUE;
            this.a = NoOpAction.NO_OP;
            for (Action b : this.actions(sDelta)) {
                cost = this.lrtaCost(sDelta, b, this.result.get(sDelta, b));
                if (!(cost < min)) continue;
                min = cost;
                this.a = b;
            }
        }
        this.s = sDelta;
        if (this.a.isNoOp()) {
            this.setAlive(false);
        }
        return this.a;
    }

    private void init() {
        this.setAlive(true);
        this.result.clear();
        this.H.clear();
        this.s = null;
        this.a = null;
    }

    private boolean goalTest(Object state) {
        return this.getProblem().isGoalState(state);
    }

    private double lrtaCost(Object s, Action action, Object sDelta) {
        if (null == sDelta) {
            return this.getHeuristicFunction().h(s);
        }
        return this.getProblem().getStepCostFunction().c(s, action, sDelta) + this.H.get(sDelta);
    }

    private Set<Action> actions(Object state) {
        return this.problem.getActionsFunction().actions(state);
    }
}

