/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.nondeterministic;

import aima.core.agent.Action;
import aima.core.search.framework.Metrics;
import aima.core.search.nondeterministic.IfStateThenPlan;
import aima.core.search.nondeterministic.NondeterministicProblem;
import aima.core.search.nondeterministic.Path;
import aima.core.search.nondeterministic.Plan;
import java.util.Set;

public class AndOrSearch {
    protected int expandedNodes;

    public Plan search(NondeterministicProblem problem) {
        this.expandedNodes = 0;
        return this.orSearch(problem.getInitialState(), problem, new Path());
    }

    public Plan orSearch(Object state, NondeterministicProblem problem, Path path) {
        ++this.expandedNodes;
        if (problem.isGoalState(state)) {
            return new Plan();
        }
        if (path.contains(state)) {
            return null;
        }
        for (Action action : problem.getActionsFunction().actions(state)) {
            Plan plan = this.andSearch(problem.getResultsFunction().results(state, action), problem, path.prepend(state));
            if (plan == null) continue;
            return plan.prepend(action);
        }
        return null;
    }

    public Plan andSearch(Set<Object> states, NondeterministicProblem problem, Path path) {
        ++this.expandedNodes;
        Object[] _states = states.toArray();
        Plan[] plans = new Plan[_states.length];
        for (int i = 0; i < _states.length; ++i) {
            plans[i] = this.orSearch(_states[i], problem, path);
            if (plans[i] != null) continue;
            return null;
        }
        Object[] steps = new Object[plans.length];
        if (plans.length > 0) {
            for (int i = 0; i < plans.length - 1; ++i) {
                steps[i] = new IfStateThenPlan(_states[i], plans[i]);
            }
            steps[steps.length - 1] = plans[plans.length - 1];
        }
        return new Plan(steps);
    }

    public Metrics getMetrics() {
        Metrics result = new Metrics();
        result.set("expandedNodes", this.expandedNodes);
        return result;
    }
}

