/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.local;

import aima.core.agent.Action;
import aima.core.search.framework.Metrics;
import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.SearchForActions;
import aima.core.search.framework.SearchForStates;
import aima.core.search.framework.SearchUtils;
import aima.core.search.framework.evalfunc.HeuristicFunction;
import aima.core.search.framework.problem.Problem;
import aima.core.util.CancelableThread;
import java.util.List;

public class HillClimbingSearch
implements SearchForActions,
SearchForStates {
    public static final String METRIC_NODES_EXPANDED = "nodesExpanded";
    public static final String METRIC_NODE_VALUE = "nodeValue";
    private HeuristicFunction hf = null;
    private final NodeExpander nodeExpander;
    private SearchOutcome outcome = SearchOutcome.FAILURE;
    private Object lastState = null;
    private Metrics metrics = new Metrics();

    public HillClimbingSearch(HeuristicFunction hf) {
        this(hf, new NodeExpander());
    }

    public HillClimbingSearch(HeuristicFunction hf, NodeExpander nodeExpander) {
        this.hf = hf;
        this.nodeExpander = nodeExpander;
    }

    @Override
    public List<Action> findActions(Problem p) {
        this.nodeExpander.useParentLinks(true);
        Node node = this.searchNode(p);
        return node == null ? SearchUtils.failure() : SearchUtils.getSequenceOfActions(node);
    }

    @Override
    public Object findState(Problem p) {
        this.nodeExpander.useParentLinks(false);
        Node node = this.searchNode(p);
        return node == null ? null : node.getState();
    }

    public Node searchNode(Problem p) {
        this.clearInstrumentation();
        this.outcome = SearchOutcome.FAILURE;
        Node current = this.nodeExpander.createRootNode(p.getInitialState());
        Node neighbor = null;
        while (!CancelableThread.currIsCanceled()) {
            this.lastState = current.getState();
            this.metrics.set(METRIC_NODE_VALUE, this.getValue(current));
            List<Node> children = this.nodeExpander.expand(current, p);
            neighbor = this.getHighestValuedNodeFrom(children, p);
            if (neighbor == null || this.getValue(neighbor) <= this.getValue(current)) {
                if (SearchUtils.isGoalState(p, current)) {
                    this.outcome = SearchOutcome.SOLUTION_FOUND;
                }
                return current;
            }
            current = neighbor;
        }
        return null;
    }

    public SearchOutcome getOutcome() {
        return this.outcome;
    }

    public Object getLastSearchState() {
        return this.lastState;
    }

    @Override
    public NodeExpander getNodeExpander() {
        return this.nodeExpander;
    }

    @Override
    public Metrics getMetrics() {
        this.metrics.set(METRIC_NODES_EXPANDED, this.nodeExpander.getNumOfExpandCalls());
        return this.metrics;
    }

    private void clearInstrumentation() {
        this.nodeExpander.resetCounter();
        this.metrics.set(METRIC_NODES_EXPANDED, 0);
        this.metrics.set(METRIC_NODE_VALUE, 0);
    }

    private Node getHighestValuedNodeFrom(List<Node> children, Problem p) {
        double highestValue = Double.NEGATIVE_INFINITY;
        Node nodeWithHighestValue = null;
        for (int i = 0; i < children.size(); ++i) {
            Node child = children.get(i);
            double value = this.getValue(child);
            if (!(value > highestValue)) continue;
            highestValue = value;
            nodeWithHighestValue = child;
        }
        return nodeWithHighestValue;
    }

    private double getValue(Node n) {
        return -1.0 * this.hf.h(n.getState());
    }

    public static enum SearchOutcome {
        FAILURE,
        SOLUTION_FOUND;

    }
}

