/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.local;

import aima.core.search.local.GeneticAlgorithm;
import aima.core.search.local.Individual;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GeneticAlgorithmForNumbers
extends GeneticAlgorithm<Double> {
    private double minimum;
    private double maximum;

    public GeneticAlgorithmForNumbers(int individualLength, double min, double max, double mutationProbability) {
        super(individualLength, Collections.emptySet(), mutationProbability);
        this.minimum = min;
        this.maximum = max;
    }

    public Individual<Double> createRandomIndividual() {
        ArrayList<Double> representation = new ArrayList<Double>(this.individualLength);
        for (int i = 0; i < this.individualLength; ++i) {
            representation.add(this.minimum + this.random.nextDouble() * (this.maximum - this.minimum));
        }
        return new Individual<Double>(representation);
    }

    @Override
    protected Individual<Double> reproduce(Individual<Double> x, Individual<Double> y) {
        ArrayList<Double> newRep = new ArrayList<Double>(x.length());
        double r = this.random.nextDouble();
        for (int i = 0; i < x.length(); ++i) {
            newRep.add(x.getRepresentation().get(i) * r + y.getRepresentation().get(i) * (1.0 - r));
        }
        return new Individual<Double>(newRep);
    }

    @Override
    protected Individual<Double> mutate(Individual<Double> child) {
        List<Double> rep = child.getRepresentation();
        ArrayList<Double> newRep = new ArrayList<Double>();
        for (double num : rep) {
            double r = this.random.nextDouble() - 0.5;
            if ((num += r * r * r * (this.maximum - this.minimum) / 2.0) < this.minimum) {
                num = this.minimum;
            } else if (num > this.maximum) {
                num = this.maximum;
            }
            newRep.add(num);
        }
        return new Individual<Double>(newRep);
    }
}

