/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.local;

import aima.core.search.framework.Metrics;
import aima.core.search.framework.problem.GoalTest;
import aima.core.search.local.FitnessFunction;
import aima.core.search.local.Individual;
import aima.core.util.CancelableThread;
import aima.core.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class GeneticAlgorithm<A> {
    protected static final String POPULATION_SIZE = "populationSize";
    protected static final String ITERATIONS = "iterations";
    protected static final String TIME_IN_MILLISECONDS = "timeInMSec";
    protected Metrics metrics = new Metrics();
    protected int individualLength;
    protected List<A> finiteAlphabet;
    protected double mutationProbability;
    protected Random random;
    private List<ProgressTracer<A>> progressTracers = new ArrayList<ProgressTracer<A>>();

    public GeneticAlgorithm(int individualLength, Collection<A> finiteAlphabet, double mutationProbability) {
        this(individualLength, finiteAlphabet, mutationProbability, new Random());
    }

    public GeneticAlgorithm(int individualLength, Collection<A> finiteAlphabet, double mutationProbability, Random random) {
        this.individualLength = individualLength;
        this.finiteAlphabet = new ArrayList<A>(finiteAlphabet);
        this.mutationProbability = mutationProbability;
        this.random = random;
        assert (this.mutationProbability >= 0.0 && this.mutationProbability <= 1.0);
    }

    public void addProgressTracer(ProgressTracer<A> pTracer) {
        this.progressTracers.add(pTracer);
    }

    public Individual<A> geneticAlgorithm(Collection<Individual<A>> initPopulation, FitnessFunction<A> fitnessFn, final int maxIterations) {
        GoalTest goalTest = new GoalTest(){

            @Override
            public boolean isGoalState(Object state) {
                return GeneticAlgorithm.this.getIterations() >= maxIterations;
            }
        };
        return this.geneticAlgorithm(initPopulation, fitnessFn, goalTest, 0L);
    }

    public Individual<A> geneticAlgorithm(Collection<Individual<A>> initPopulation, FitnessFunction<A> fitnessFn, GoalTest goalTest, long maxTimeMilliseconds) {
        Individual<A> bestIndividual = null;
        List<Individual<A>> population = new ArrayList<Individual<A>>(initPopulation);
        this.validatePopulation(population);
        this.updateMetrics(population, 0, 0L);
        long startTime = System.currentTimeMillis();
        int itCount = 0;
        do {
            population = this.nextGeneration(population, fitnessFn);
            bestIndividual = this.retrieveBestIndividual(population, fitnessFn);
            this.updateMetrics(population, ++itCount, System.currentTimeMillis() - startTime);
        } while ((maxTimeMilliseconds <= 0L || System.currentTimeMillis() - startTime <= maxTimeMilliseconds) && !CancelableThread.currIsCanceled() && !goalTest.isGoalState(bestIndividual));
        this.notifyProgressTracers(itCount, population);
        return bestIndividual;
    }

    public Individual<A> retrieveBestIndividual(Collection<Individual<A>> population, FitnessFunction<A> fitnessFn) {
        Individual<A> bestIndividual = null;
        double bestSoFarFValue = Double.NEGATIVE_INFINITY;
        for (Individual<A> individual : population) {
            double fValue = fitnessFn.apply(individual);
            if (!(fValue > bestSoFarFValue)) continue;
            bestIndividual = individual;
            bestSoFarFValue = fValue;
        }
        return bestIndividual;
    }

    public void clearInstrumentation() {
        this.updateMetrics(new ArrayList<Individual<A>>(), 0, 0L);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public int getPopulationSize() {
        return this.metrics.getInt(POPULATION_SIZE);
    }

    public int getIterations() {
        return this.metrics.getInt(ITERATIONS);
    }

    public long getTimeInMilliseconds() {
        return this.metrics.getLong(TIME_IN_MILLISECONDS);
    }

    protected void updateMetrics(Collection<Individual<A>> population, int itCount, long time) {
        this.metrics.set(POPULATION_SIZE, population.size());
        this.metrics.set(ITERATIONS, itCount);
        this.metrics.set(TIME_IN_MILLISECONDS, time);
    }

    protected List<Individual<A>> nextGeneration(List<Individual<A>> population, FitnessFunction<A> fitnessFn) {
        ArrayList<Individual<A>> newPopulation = new ArrayList<Individual<A>>(population.size());
        for (int i = 0; i < population.size(); ++i) {
            Individual<A> x = this.randomSelection(population, fitnessFn);
            Individual<A> y = this.randomSelection(population, fitnessFn);
            Individual<A> child = this.reproduce(x, y);
            if (this.random.nextDouble() <= this.mutationProbability) {
                child = this.mutate(child);
            }
            newPopulation.add(child);
        }
        this.notifyProgressTracers(this.getIterations(), population);
        return newPopulation;
    }

    protected Individual<A> randomSelection(List<Individual<A>> population, FitnessFunction<A> fitnessFn) {
        Individual<A> selected = population.get(population.size() - 1);
        double[] fValues = new double[population.size()];
        for (int i = 0; i < population.size(); ++i) {
            fValues[i] = fitnessFn.apply(population.get(i));
        }
        fValues = Util.normalize(fValues);
        double prob = this.random.nextDouble();
        double totalSoFar = 0.0;
        for (int i = 0; i < fValues.length; ++i) {
            if (!(prob <= (totalSoFar += fValues[i]))) continue;
            selected = population.get(i);
            break;
        }
        selected.incDescendants();
        return selected;
    }

    protected Individual<A> reproduce(Individual<A> x, Individual<A> y) {
        int c = this.randomOffset(this.individualLength);
        ArrayList<A> childRepresentation = new ArrayList<A>();
        childRepresentation.addAll(x.getRepresentation().subList(0, c));
        childRepresentation.addAll(y.getRepresentation().subList(c, this.individualLength));
        Individual child = new Individual(childRepresentation);
        return child;
    }

    protected Individual<A> mutate(Individual<A> child) {
        int mutateOffset = this.randomOffset(this.individualLength);
        int alphaOffset = this.randomOffset(this.finiteAlphabet.size());
        ArrayList<A> mutatedRepresentation = new ArrayList<A>(child.getRepresentation());
        mutatedRepresentation.set(mutateOffset, this.finiteAlphabet.get(alphaOffset));
        Individual<A> mutatedChild = new Individual<A>(mutatedRepresentation);
        return mutatedChild;
    }

    protected int randomOffset(int length) {
        return this.random.nextInt(length);
    }

    protected void validatePopulation(Collection<Individual<A>> population) {
        if (population.size() < 1) {
            throw new IllegalArgumentException("Must start with at least a population of size 1");
        }
        for (Individual<A> individual : population) {
            if (individual.length() == this.individualLength) continue;
            throw new IllegalArgumentException("Individual [" + individual + "] in population is not the required length of " + this.individualLength);
        }
    }

    private void notifyProgressTracers(int itCount, Collection<Individual<A>> generation) {
        for (ProgressTracer<A> tracer : this.progressTracers) {
            tracer.traceProgress(this.getIterations(), generation);
        }
    }

    public static interface ProgressTracer<A> {
        public void traceProgress(int var1, Collection<Individual<A>> var2);
    }
}

